/**
 * External dependencies
 */
import { useState, useEffect } from '@wordpress/element';
import { useDispatch } from '@wordpress/data';
import { HashRouter as Router, Routes, Route } from 'react-router-dom';

/**
 * Internal dependencies
 */
import getRoute from './routes';
import Layout from './components/layout/Layout';
import jobstore from './data/job';

const App = () => {
    const dispatch = useDispatch();
    const [jobLimitStatus, setJobLimitStatus] = useState(false);
    
    useEffect(() => {
        dispatch(jobstore).getHasJobLimit()
        .then((respons: any) => {
            setJobLimitStatus(respons);
        })
    }, []);
    const routes = getRoute({ jobLimit: jobLimitStatus });
    return (
        <Router>
            <Layout>
                <Routes>
                    {routes.map((route, index) => (
                        route.permission && (
                            <Route
                            key={index}
                            path={route.path}
                            element={<route.element />}
                            ></Route>
                        )
                    ))}
                </Routes>
            </Layout>
        </Router>
    );
};

export default App;
