/**
 * External dependencies
 */
import { useState } from '@wordpress/element';

type Props = {
    onClick: (val: any) => void;
};

const FilterButton = ({ onClick = () => {} }: Props) => {
    const [filterItemOpen, setFilterItemOpen] = useState(false);
    return (
        <button
            onClick={() => {
                setFilterItemOpen(!filterItemOpen);
                onClick(!filterItemOpen);
            }}
            className="h-[38px] flex items-center py-1 px-[14px] border border-border-dark rounded text-[16px] text-b2-table"
        >
            <i className="tio-filter_outlined"></i>
        </button>
    );
};

export default FilterButton;
