/**
 * External dependencies.
 */
import { twMerge } from 'tailwind-merge';
import { Link } from 'react-router-dom';

/**
 * Internal dependencies.
 */
import { TButton } from '../../interfaces';

const IconButton = (props: TButton) => {
    const {
        text = '',
        href = undefined,
        icon = null,
        type = 'button',
        btnStyle = 'default',
        outline = false,
        buttonCustomClass = '',
        disabled = false,
        onClick = () => {},
    } = props;

    const getClassName = () => {
        let className = `inline-flex items-center gap-1 transition decoration-transparent`;
        if (btnStyle === 'secondary') {
            className += ` px-4 py-2 rounded-md font-medium text-sm text-white bg-secondary`;
            className += ` hover:bg-opacity-80 hover:text-white`;
            className += ` focus:outline-none focus:shadow-none`;
        }
        if (btnStyle === 'secondary' && outline) {
            className += ` border border-secondary text-secondary bg-transparent`;
            className += ` hover:text-secondary`;
        }
        if (btnStyle === 'action') {
            className += ` px-2.5 rounded-xsm text-[13px]`;
            className += ` hover:text-secondary`;
            className += ` focus:outline-none focus:shadow-none`;
        }

        // Add opacity for disabled button
        if (disabled) {
            className += ' opacity-50 cursor-not-allowed';
        }

        // Add custom class name if provided
        if (
            typeof buttonCustomClass !== 'undefined' &&
            buttonCustomClass !== null
        ) {
            className = `${buttonCustomClass} ${className}`;
        }

        return twMerge(className);
    };

    return (
        <>
            {typeof href !== 'undefined' ? (
                <Link to={href} className={getClassName()} onClick={onClick}>
                    {icon}
                    {text}
                </Link>
            ) : (
                <button
                    type={type}
                    onClick={onClick}
                    className={getClassName()}
                >
                    {icon}
                    {text}
                </button>
            )}
        </>
    );
};

export default IconButton;
