/**
 * External dependencies
 */
const lodash = require('lodash');

type Props = {
    data: Array<any>;
    onClick: (val: any) => void;
    activeValue: string;
};

const TabButton = ({
    data = [],
    onClick = () => {},
    activeValue = '',
}: Props) => {
    return (
        <div className="flex items-center flex-wrap gap-[5px] mb-5">
            {data?.map((btnText, index) => (
                <button
                    onClick={() => {
                        onClick(btnText);
                    }}
                    key={index}
                    className={`${
                        lodash.isEqual(activeValue, btnText.value)
                            ? 'border-lightblue text-primary bg-lightblue'
                            : 'text-b1-notice-comment border-border-mid bg-white'
                    } flex items-center gap-1 py-[7px] px-[15px] text-b3-mid rounded-md border transition hover:text-primary`}
                >
                    <span>{btnText.label}</span>
                    {btnText.count && <span>{`(${btnText.count})`}</span>}
                </button>
            ))}
        </div>
    );
};

export default TabButton;
