/**
 * External dependencies
 */
import { useState } from '@wordpress/element';

type Props = {
    buttonText: React.ReactNode;
    collapseItem: React.ReactNode;
};

const Collapse = ({ buttonText, collapseItem }: Props) => {
    const [isExpanded, setIsExpanded] = useState(true);
    return (
        <div className="collapse-accordion">
            <button
                type="button"
                className="toggle-button"
                onClick={() => setIsExpanded(!isExpanded)}
            >
                <span>{buttonText}</span>
                <span className="toggle-icon">
                    {isExpanded ? (
                        <i className="tio-remove" />
                    ) : (
                        <i className="tio-add" />
                    )}
                </span>
            </button>
            {isExpanded && (
                <div className="collapsed-item-wrap">{collapseItem}</div>
            )}
        </div>
    );
};

export default Collapse;
