import { Fragment } from '@wordpress/element';
import { Menu, Transition } from '@headlessui/react';

type Props = {
    children: React.ReactNode;
    menusClass?: string;
};

const Dropdown = ({ children, menusClass = '' }: Props) => {
    return (
        <div>
            <Menu as="div" className="relative inline-block">
                <div>
                    <Menu.Button className="w-5 mt-[1px] text-b2-table text-[20px]">
                        <i className="tio-more_vertical"></i>
                    </Menu.Button>
                </div>
                <Transition
                    as={Fragment}
                    enter="transition ease-out duration-100"
                    enterFrom="transform opacity-0 scale-95"
                    enterTo="transform opacity-100 scale-100"
                    leave="transition ease-in duration-75"
                    leaveFrom="transform opacity-100 scale-100"
                    leaveTo="transform opacity-0 scale-95"
                >
                    <Menu.Items
                        className={`${menusClass} absolute right-0 mt-2 origin-top-right z-10 rounded-[5px] bg-white shadow-lg ring-1 ring-black/5 focus:outline-none`}
                    >
                        <div className="p-[10px] grid gap-[2px]">
                            {children}
                        </div>
                    </Menu.Items>
                </Transition>
            </Menu>
        </div>
    );
};

export default Dropdown;
