/**
 * External dependencies.
 */
import { twMerge } from 'tailwind-merge';

interface IInputLabel {
    /**
     * Input level children props.
     */
    children: React.ReactNode | string;

    /**
     * Input html for attribute.
     */
    htmlFor?: string;

    /**
     * Custom Class name.
     */
    className?: string;
}

export default function InputLabel({
    children = <></>,
    htmlFor,
    className = '',
}: IInputLabel) {
    return (
        <label
            className={`${className} block text-headline text-b3-bold mb-[8px]`}
            htmlFor={htmlFor}
        >
            {children}
        </label>
    );
}
