type Props = {
    name?: string;
    placeholder?: string;
    onChange?: (val: any) => void;
};

const SearchInput = ({
    name = 'search',
    placeholder = 'Search...',
    onChange = () => {},
}: Props) => {
    return (
        <div className="relative">
            <button
                type="button"
                className=" absolute top-[4px] left-[14px] z-10 text-[16px] text-b3-meta"
            >
                <i className="tio-search"></i>
            </button>
            <input
                type="text"
                name={name}
                placeholder={placeholder}
                onChange={(text) => {
                    onChange(text.target.value);
                }}
                className="w-[220px] min-h-[38px] !pl-[36px] !py-1 !px-[15px] text-[14px] !text-b1-notice-comment !border !border-solid !border-border-dark !rounded focus:!outline-none focus:!shadow-none focus:ring-0"
            />
        </div>
    );
};

export default SearchInput;
