export const inputStyle = `!min-h-[42px] !bg-white !placeholder:text-b2-table transition !py-1 !px-5 !rounded !text-b3-regular 
!text-b1-notice-comment border-1 !border-solid !border-border-dark !shadow-none placeholder:text-b2-table focus:outline-none focus:!border-primary 
focus:!shadow-none focus:ring-0 required:border-red-500 !w-full !shadow-none`;

export const checkboxStyle =
    '!h-4 !w-4 !mr-2.5 !border-2 !border-border-dark !rounded-[2px] !text-primary cursor-pointer focus:![box-shadow:none] checked:bg-checkbox-size checked:bg-checkbox-position checked:bg-checkbox-check checked:before:!content-none checked:!border-primary';

export const selectStyles = {
    container: (base: any) => ({
        ...base,
        width: '100%',
        margin: '0',
        padding: '0',
        border: 'none',
        borderRadius: '0',
        boxShadow: 'none',
        backgroundColor: 'transparent',
        '&:hover': {
            border: 'none',
            boxShadow: 'none',
            backgroundColor: 'transparent',
        },
    }),
    control: (base: any, state: any) => ({
        ...base,
        borderColor: state.isFocused ? '#323DA5' : '#A8ABBD',
        borderRadius: '10px',
        boxShadow: 'none',
        padding: '2px 0',
        '&:hover': {
            borderColor: '#323DA5',
        },
        overflowY: 'auto',
        height: 'auto',
        minHeight: '42px',
        fontSize: '14px',
    }),
    valueContainer: (base: any) => ({
        ...base,
        padding: '0',
        cursor: 'pointer',
        paddingLeft: '20px',
        textTransform: 'capitalize',
    }),
    multiValue: (base: any) => ({
        ...base,
        backgroundColor: '#323DA5',
    }),
    multiValueLabel: (base: any) => ({
        ...base,
        color: '#ffffff',
    }),
    multiValueRemove: (base: any) => ({
        ...base,
        color: '#ffffff',
        borderRadius: '0',
        transition: '0.3s',
        ':hover': {
            backgroundColor: '#FF7F5C',
            color: 'white',
        },
    }),
    placeholder: (base: any) => ({
        ...base,
        color: '#767695',
    }),
    input: (base: any) => ({
        ...base,
        boxShadow: 'none',
        color: '#323232',
        '&:focus': {
            boxShadow: 'none !important',
        },
    }),
    clearIndicator: (base: any) => ({
        ...base,
        display: 'none',
    }),
    indicatorSeparator: () => ({
        display: 'none',
    }),
    dropdownIndicator: (base: any) => ({
        ...base,
        fontSize: '10px',
        color: '#5D5D7A',
        padding: '8px 15px 8px 10px',
        width: '41px',
        '&:hover': {
            color: '#5D5D7A',
        },
    }),
    menu: (base: any) => ({
        ...base,
        borderRadius: '10px',
        zIndex: 10,
        margin: 0,
    }),
    menuList: (base: any) => ({
        ...base,
        width: 'auto',
        minWidth: '200px',
        backgroundColor: '#FFFFFF',
        borderRadius: '10px',
        fontSize: '14px',
        textTransform: 'capitalize',
    }),
    option: (base: any, state: any) => ({
        ...base,
        backgroundColor: state.isSelected ? '#323DA5' : '#ffffff',
        color: state.isSelected ? '#ffffff' : '#323232',
        '&:hover': {
            backgroundColor: '#323DA5',
            color: '#ffffff',
        },
    }),
};
export const selectStylesSM = {
    container: (base: any) => ({
        ...base,
        width: '100%',
        minWidth: '130px',
        margin: '0',
        padding: '0',
        border: 'none',
        borderRadius: '0',
        boxShadow: 'none',
        backgroundColor: 'transparent',
        '&:hover': {
            border: 'none',
            boxShadow: 'none',
            backgroundColor: 'transparent',
        },
    }),
    control: (base: any, state: any) => ({
        ...base,
        borderColor: state.isFocused ? '#A8ABBD' : '#A8ABBD',
        borderRadius: '10px',
        boxShadow: 'none',
        '&:hover': {
            borderColor: '#A8ABBD',
        },
        height: '38px',
        minHeight: '38px',
        fontSize: '14px',
    }),
    valueContainer: (base: any) => ({
        ...base,
        padding: '0',
        cursor: 'pointer',
        paddingLeft: '15px',
    }),
    singleValue: (base: any) => ({
        ...base,
        color: '#5D5D7A',
    }),
    placeholder: (base: any) => ({
        ...base,
        color: '#5D5D7A',
    }),
    input: (base: any, state: any) => ({
        ...base,
        boxShadow: 'none',
        color: '#5D5D7A',
        '&:focus': {
            boxShadow: 'none',
        },
    }),
    indicatorSeparator: () => ({
        display: 'none',
    }),
    dropdownIndicator: (base: any) => ({
        ...base,
        color: '#5D5D7A',
        padding: '8px 15px 8px 10px',
        width: '40px',
        '&:hover': {
            color: '#5D5D7A',
        },
    }),
    menu: (base: any) => ({
        ...base,
        borderRadius: '10px',
        zIndex: 10,
        margin: 0,
    }),
    menuList: (base: any) => ({
        ...base,
        width: 'auto',
        backgroundColor: '#FFFFFF',
        borderRadius: '10px',
        padding: '5px 0',
        fontSize: '14px',
    }),
    option: (base: any, state: any) => ({
        ...base,
        margin: '3px 0',
        padding: '5px 15px',
        backgroundColor: state.isSelected ? '#323DA5' : '#ffffff',
        color: state.isSelected ? '#ffffff' : '#5D5D7A',
        '&:hover': {
            backgroundColor: '#323DA5',
            color: '#ffffff',
        },
    }),
};
export const selectStylesMd = {
    container: (base: any) => ({
        ...base,
        width: '100%',
        minWidth: '130px',
        margin: '0',
        padding: '0',
        border: 'none',
        borderRadius: '0',
        boxShadow: 'none',
        backgroundColor: 'transparent',
        '&:hover': {
            border: 'none',
            boxShadow: 'none',
            backgroundColor: 'transparent',
        },
    }),
    control: (base: any, state: any) => ({
        ...base,
        borderColor: state.isFocused ? '#CCCEDE' : '#CCCEDE',
        borderRadius: '10px',
        boxShadow: 'none',
        backgroundColor: '#ffffff',
        '&:hover': {
            borderColor: '#CCCEDE',
        },
        height: '42px',
        minHeight: '42px',
        fontSize: '14px',
        fontWeight: '500',
    }),
    valueContainer: (base: any) => ({
        ...base,
        padding: '0',
        cursor: 'pointer',
        paddingLeft: '10px',
    }),
    singleValue: (base: any) => ({
        ...base,
        color: '#78787C',
        margin: '0',
    }),
    placeholder: (base: any) => ({
        ...base,
        color: '#78787C',
    }),
    input: (base: any) => ({
        ...base,
        boxShadow: 'none',
        color: '#78787C',
    }),
    indicatorSeparator: () => ({
        display: 'none',
    }),
    dropdownIndicator: (base: any) => ({
        ...base,
        color: '#78787C',
        padding: '8px 10px 8px 8px',
        fontSize: '10px',
        width: '30px',
    }),
    menu: (base: any) => ({
        ...base,
        borderRadius: '10px',
        zIndex: 10,
        margin: 0,
    }),
    menuList: (base: any) => ({
        ...base,
        width: 'auto',
        // minWidth: '200px',
        backgroundColor: '#FFFFFF',
        borderRadius: '10px',
        fontSize: '14px',
    }),
    option: (base: any, state: any) => ({
        ...base,
        backgroundColor: state.isSelected ? '#323DA5' : '#ffffff',
        color: state.isSelected ? '#ffffff' : '#323232',
        '&:hover': {
            backgroundColor: '#323DA5',
            color: '#ffffff',
        },
    }),
};
export const selectStyleTransparent = {
    container: (base: any) => ({
        ...base,
        width: '100%',
        margin: '0',
        padding: '0',
        border: 'none',
        borderRadius: '0',
        boxShadow: 'none',
        backgroundColor: 'transparent',
        '&:hover': {
            border: 'none',
            boxShadow: 'none',
            backgroundColor: 'transparent',
        },
    }),
    control: (base: any, state: any) => ({
        ...base,
        border: 'none',
        borderColor: state.isFocused ? '#CCCEDE' : '#CCCEDE',
        borderRadius: '10px',
        boxShadow: 'none',
        '&:hover': {
            borderColor: '#CCCEDE',
        },
        height: '30px',
        minHeight: '30px',
        fontSize: '14px',
        backgroundColor: 'transparent',
    }),
    valueContainer: (base: any) => ({
        ...base,
        padding: '0',
        cursor: 'pointer',
    }),
    placeholder: (base: any) => ({
        ...base,
        color: '#8B8C93',
    }),
    input: (base: any) => ({
        ...base,
        boxShadow: 'none',
        color: '#323232',
    }),
    indicatorSeparator: () => ({
        display: 'none',
    }),
    dropdownIndicator: (base: any) => ({
        ...base,
        color: '#8B8C93',
        padding: '5px',
        paddingRight: '0',
        fontSize: '10px',
    }),
    menu: (base: any) => ({
        ...base,
        borderRadius: '10px',
        zIndex: 10,
        margin: 0,
    }),
    menuList: (base: any) => ({
        ...base,
        width: 'auto',
        // minWidth: '200px',
        backgroundColor: '#FFFFFF',
        borderRadius: '10px',
        fontSize: '14px',
    }),
    option: (base: any, state: any) => ({
        ...base,
        backgroundColor: state.isSelected ? '#323DA5' : '#ffffff',
        color: state.isSelected ? '#ffffff' : '#323232',
        '&:hover': {
            backgroundColor: '#323DA5',
            color: '#ffffff',
        },
    }),
};
export const selectStylesWithSearch = {
    container: (base: any) => ({
        ...base,
        width: '100%',
        margin: '0',
        padding: '0',
        border: 'none',
        borderRadius: '0',
        boxShadow: 'none',
        backgroundColor: 'transparent',
        '&:hover': {
            border: 'none',
            boxShadow: 'none',
            backgroundColor: 'transparent',
        },
    }),
    control: (base: any, state: any) => ({
        ...base,
        borderColor: state.isFocused ? '#CCCEDE' : '#CCCEDE',
        borderRadius: '10px',
        boxShadow: 'none',
        padding: '2px 0',
        '&:hover': {
            borderColor: '#CCCEDE',
        },
        overflowY: 'auto',
        height: '42px',
        minHeight: '42px',
        fontSize: '14px',
    }),
    valueContainer: (base: any) => ({
        ...base,
        padding: '0',
        cursor: 'pointer',
        paddingLeft: '20px',
    }),
    multiValue: (base: any) => ({
        ...base,
        backgroundColor: '#323DA5',
    }),
    multiValueLabel: (base: any) => ({
        ...base,
        color: '#ffffff',
    }),
    multiValueRemove: (base: any) => ({
        ...base,
        color: '#ffffff',
        borderRadius: '0',
        transition: '0.3s',
        ':hover': {
            backgroundColor: '#FF7F5C',
            color: 'white',
        },
    }),
    placeholder: (base: any) => ({
        ...base,
        color: '#8B8C93',
    }),
    input: (base: any) => ({
        ...base,
        boxShadow: 'none',
        color: '#323232',
        height: '32px',
        '&:focus': {
            boxShadow: 'none !important',
        },
    }),
    clearIndicator: (base: any) => ({
        ...base,
        display: 'none',
    }),
    indicatorSeparator: () => ({
        display: 'none',
    }),
    dropdownIndicator: (base: any) => ({
        ...base,
        color: '#8B8C93',
        padding: '8px 20px',
        fontSize: '10px',
    }),
    menu: (base: any) => ({
        ...base,
        borderRadius: '10px',
        zIndex: 10,
        margin: 0,
    }),
    menuList: (base: any) => ({
        ...base,
        width: 'auto',
        minWidth: '200px',
        backgroundColor: '#FFFFFF',
        borderRadius: '10px',
        fontSize: '14px',
    }),
    option: (base: any, state: any) => ({
        ...base,
        backgroundColor: state.isSelected ? '#323DA5' : '#ffffff',
        color: state.isSelected ? '#ffffff' : '#323232',
        '&:hover': {
            backgroundColor: '#323DA5',
            color: '#ffffff',
        },
    }),
};

export const bulkSelectStyles = {
    container: (base: any) => ({
        ...base,
        width: '100%',
        minWidth: '190px',
        margin: '0',
        padding: '0',
        border: 'none',
        borderRadius: '0',
        boxShadow: 'none',
        backgroundColor: 'transparent',
        '&:hover': {
            border: 'none',
            boxShadow: 'none',
            backgroundColor: 'transparent',
        },
    }),
    control: (base: any, state: any) => ({
        ...base,
        border: 'none',
        backgroundColor: state.isFocused ? 'transparent' : 'transparent',
        boxShadow: 'none',
        '&:hover': {
            borderColor: '#CCCEDE',
        },
        height: '36px',
        minHeight: '36px',
        fontSize: '14px',
    }),
    valueContainer: (base: any) => ({
        ...base,
        padding: '0',
        cursor: 'pointer',
        paddingLeft: '15px',
    }),
    singleValue: (base: any) => ({
        ...base,
        color: '#8B8C93',
    }),
    placeholder: (base: any) => ({
        ...base,
        color: '#8B8C93',
    }),
    input: (base: any) => ({
        ...base,
        boxShadow: 'none',
        color: '#8B8C93',
    }),
    indicatorSeparator: () => ({
        display: 'none',
    }),
    dropdownIndicator: (base: any) => ({
        ...base,
        color: '#8B8C93',
        padding: '8px 15px 8px 10px',
        fontSize: '10px',
        width: '46px',
    }),
    menu: (base: any) => ({
        ...base,
        borderRadius: '10px',
        zIndex: 10,
        margin: 0,
    }),
    menuList: (base: any) => ({
        ...base,
        width: 'auto',
        // minWidth: '200px',
        backgroundColor: '#FFFFFF',
        borderRadius: '10px',
        fontSize: '14px',
    }),
    option: (base: any, state: any) => ({
        ...base,
        backgroundColor: state.isSelected ? '#323DA5' : '#ffffff',
        color: state.isSelected ? '#ffffff' : '#323232',
        '&:hover': {
            backgroundColor: '#323DA5',
            color: '#ffffff',
        },
    }),
};
