/**
 * External dependencies.
 */
import { CKEditor } from '@ckeditor/ckeditor5-react';
import {
    ClassicEditor,
    Bold,
    Essentials,
    List,
    Link,
    Italic,
    Mention,
    Paragraph,
    Undo,
    HtmlEmbed,
    Clipboard,
} from 'ckeditor5';

import 'ckeditor5/ckeditor5.css';

interface ITextEditor {
    id: string;
    value?: any;
    onChange?: (val: any) => void;
    placeholder?: React.CSSProperties['placeholder'];
    height?: string;
}

export default function TextEditor({
    height = '150px',
    id,
    value,
    onChange,
    placeholder,
}: ITextEditor) {
    return (
        <CKEditor
            editor={ClassicEditor}
            config={{
                toolbar: {
                    items: [
                        'bold',
                        'italic',
                        'link',
                        'bulletedList',
                        'numberedList',
                        // 'htmlEmbed',
                    ],
                },
                plugins: [
                    Bold,
                    Essentials,
                    Italic,
                    Link,
                    List,
                    Mention,
                    Paragraph,
                    Undo,
                    HtmlEmbed,
                    Clipboard,
                ],
                htmlEmbed: {
                    showPreviews: true,
                    sanitizeHtml: (inputHtml) => ({
                        html: inputHtml,
                        hasChanged: false,
                    }),
                },
            }}
            onReady={(editor) => {
                // You can store the "editor" and use when it is needed.
                if (typeof editor !== 'undefined' && editor !== null) {
                    editor.editing.view.change((writer) => {
                        writer.setStyle(
                            {
                                height,
                                //  border: '1px solid rgba(233, 238, 248, 0.9)',
                            },
                            editor.editing.view.document.getRoot()
                        );
                    });
                    // Custom paste handling to allow raw HTML
                    editor.plugins
                        .get('Clipboard')
                        .on('inputTransformation', (evt, data) => {
                            // Prevent CKEditor from modifying pasted HTML
                            data.content = editor.data.processor.toView(
                                data.dataTransfer.getData('text/html') ||
                                    data.dataTransfer.getData('text/plain')
                            );
                        });
                }
            }}
            placeholder={placeholder}
            data={
                typeof value === 'undefined' || value.length === 0
                    ? '<p></p>'
                    : value
            }
            onChange={(event, editor) => {
                if (typeof editor !== 'undefined' && editor !== null) {
                    const data = editor.getData();
                    onChange({ name: id, value: data });
                }
            }}
        />
    );
}
