/* eslint-disable @wordpress/i18n-no-variables */
/**
 * External dependencies
 */
import { Link, useLocation } from 'react-router-dom';
import { __ } from '@wordpress/i18n';
import { useSelect } from '@wordpress/data';

/**
 * Internal dependencies
 */
import useMenuFix from '../../hooks/useMenuFix';
import getRoute from '../../routes';
import generalSettings from '../../data/general-settings';

function NavMenu() {
    const location = useLocation();
    const settings: object = useSelect(
        (select) => select(generalSettings).getGeneralSettings(),
        []
    );

    // Fix admin menu sidebar links.
    useMenuFix();

    const navRoutes = location.pathname.split('/');

    const isActive = (path: string) => {
        const splitPath = path.split('/');
        const routeName: string =
            typeof navRoutes[1] !== 'undefined' ? navRoutes[1] : splitPath[1];

        if (routeName === splitPath[1]) {
            return true;
        }

        return false;
    };

    const siteBasePath = window.location.pathname;
    const pathIndex = siteBasePath.lastIndexOf('wp-admin');
    const livePath = siteBasePath.substring(0, pathIndex);
    const routes = getRoute({});

    return (
        <ul className="list-none pl-0 m-0 mb-[-5px] mt-[-5px]">
            {routes.map(
                (route, index) =>
                    route.navShow && (
                        <li key={index} className="p-0 mb-[5px] mt-[5px]">
                            <Link
                                to={route.path}
                                className={`flex flex-col items-center gap-1 text-background py-2.5 px-2 rounded text-[14px] text-center transition-all 
                                    shadow-none outline-none hover:text-background hover:bg-primary-active focus:shadow-none focus:bg-primary-active 
                                    focus:text-background ${
                                        isActive(route.path)
                                            ? 'bg-primary-active'
                                            : 'bg-transparent'
                                    }`}
                            >
                                <span className="text-[18px] leading-[1]">
                                    <i className={route.icon}></i>
                                </span>
                                <span>
                                    {__(`${route.name}`, 'ai-job-listing')}
                                </span>
                            </Link>
                        </li>
                    )
            )}
            <li className="p-0 mb-[5px] mt-[5px]">
                <a
                    href={`${livePath}${settings?.page_slug}/`}
                    target="_blank"
                    rel="noopener noreferrer"
                    className="flex flex-col items-center gap-1 text-background py-2.5 px-2 rounded text-[14px] text-center transition-all 
                        shadow-none outline-none hover:text-background hover:!bg-primary-active focus:shadow-none focus:bg-transparent 
                        focus:text-background"
                >
                    <span className="text-[18px] leading-[1]">
                        <i className="tio-open_in_new"></i>
                    </span>
                    <span>Live Site</span>
                </a>
            </li>
        </ul>
    );
}

export default NavMenu;
