import { TPageTitle } from '../../interfaces';

const PageTitle = ({
    text,
    customClass = '',
    areaClass = '',
    areaSpace = '',
    backButton = false,
}: TPageTitle) => {
    return (
        <div className={`flex item-center gap-2.5 ${areaClass} ${areaSpace ? areaSpace : 'mb-5'}`}>
            {backButton && (
                <button
                    type="button"
                    className="flex items-center justify-center h-[34px] w-[34px] rounded-full bg-white text-[16px] text-b2-table transition-all hover:bg-secondary hover:text-white"
                    onClick={() => window.history.back()}
                >
                    <i className="tio-back_ui"></i>
                </button>
            )}
            <h1 className={`${customClass} mb-0`}>{text}</h1>
        </div>
    );
};

export default PageTitle;
