/**
 * External dependencies
 */
import { memo } from '@wordpress/element';
import { __ } from '@wordpress/i18n';

/**
 * Internal dependencies
 */
import NavMenu from './NavMenu';
import brandLogo from '../../style/images/logo.svg';

const Sidebar = () => {
    return (
        <aside className="ai-job-listing-sidebar bg-primary rounded">
            <div>
                <div className="mb-[25px] text-center">
                    <img
                        className="mx-auto my-0 w-[60px]"
                        src={brandLogo}
                        alt="Logo"
                    />
                </div>
                <NavMenu />
            </div>
        </aside>
    );
};

export default memo(Sidebar);
