/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { Link, useLocation } from 'react-router-dom';
import { Fragment } from '@wordpress/element';
import { Menu, Transition } from '@headlessui/react';

/**
 * Internal dependencies.
 */
import logo from '../../style/images/bg-logo.svg';

const TopbarHeader = () => {
    const location = useLocation();
    const navRoutes = location.pathname.split('/');
    const isActive = (path: string) => {
        const splitPath = path.split('/');
        const routeName: string =
            typeof navRoutes[1] !== 'undefined' ? navRoutes[1] : splitPath[1];

        if (routeName === splitPath[1]) {
            return true;
        }

        return false;
    };

    const menuLink = [
        {
            link: '/',
            title: __('Welcome', 'ai-job-listing'),
        },
        {
            link: '/job-list',
            title: __('Job List', 'ai-job-listing'),
        },
        {
            link: '/applicants',
            title: __('Applicants', 'ai-job-listing'),
        },
        {
            link: '/settings',
            title: __('Settings', 'ai-job-listing'),
        }
    ];

    return ( 
        <div className="px-7 ml-[-10px] bg-white">
            <div className="flex items-center gap-10 justify-between">
                <div className="mr-6">
                    <img
                        className="my-0 mx-auto"
                        src={logo}
                        alt="Ai Job Listing"
                    />
                </div>
                <div className="flex-1">
                    <div className="flex items-center gap-7">
                        {menuLink.map((item, index) => (
                            <Link
                            key={index}
                                to={item.link}
                                className={`px-1 py-5 border-b text-b1-mid shadow-none outline-none transition-all hover:text-secondary focus:shadow-none focus:text-secondary ${
                                        isActive(item.link)
                                            ? 'border-secondary text-secondary'
                                            : 'border-white text-headline'
                                    }`}
                                >
                                    {item.title}
                            </Link>
                        ))}
                    </div>
                </div>
                <div>
                    {/* <div className="flex items-center gap-6">
                        <div className="px-7 py-[3px] border border-border-mid bg-background rounded-sm text-b3-regular text-[#2F3448]">Free</div>
                        <div>
                            <Menu as="div" className="relative inline-block">
                                <div>
                                    <Menu.Button className="h-8 w-8 flex items-center justify-center bg-background rounded-full text-b2-table text-[18px] relative">
                                        <i className="tio-notifications"></i>
                                        <span className="h-[14px] w-5 flex items-center justify-center border-1 border-white bg-secondary rounded-[100px] text-[10px] text-white absolute top-[-8px] right-[-8px]">5</span>
                                    </Menu.Button>
                                </div>
                                <Transition
                                    as={Fragment}
                                    enter="transition ease-out duration-100"
                                    enterFrom="transform opacity-0 scale-95"
                                    enterTo="transform opacity-100 scale-100"
                                    leave="transition ease-in duration-75"
                                    leaveFrom="transform opacity-100 scale-100"
                                    leaveTo="transform opacity-0 scale-95"
                                >
                                    <Menu.Items
                                        className={`w-[200px] absolute right-0 mt-2 origin-top-right z-10 rounded-[5px] bg-white shadow-lg ring-1 ring-black/5 focus:outline-none`}
                                    >
                                        <div className="p-[10px] grid gap-[2px] text-[14px]">
                                            <Menu.Item>
                                               <div className="py-2 border-b border-border-light">This is number one notification</div>
                                            </Menu.Item>
                                            <Menu.Item>
                                               <div className="py-2">This is number two notification</div>
                                            </Menu.Item>
                                        </div>
                                    </Menu.Items>
                                </Transition>
                            </Menu>
                        </div>
                    </div> */}
                </div>
            </div>
        </div>
    );
}
 
export default TopbarHeader;