export interface TLoadingBlock {
    block?: number;
}

const LoaderJobBox = ({ block = 1 }: TLoadingBlock) => {
    return (
        <div className="grid gap-5 loader-job-box">
            {[...Array(block === 0 ? 1 : block)].map((e, i) => (
                <div
                    className="loader-box-list p-8 border border-border-mid rounded bg-white"
                    key={i}
                >
                    <div className="animate-pulse">
                        <div className="h-3 mb-5 bg-border-mid rounded loader-line big"></div>
                        <div className="h-1.5 mb-1 bg-border-mid rounded loader-line"></div>
                        <div className="h-1.5 mb-1 bg-border-mid rounded loader-line"></div>
                        <div className="h-1.5 mb-1 bg-border-mid rounded loader-line"></div>
                        <div className="h-1.5 mb-5 bg-border-mid rounded loader-line"></div>
                        <div className="h-3 bg-border-mid rounded loader-line last"></div>
                    </div>
                </div>
            ))}
        </div>
    );
};

export default LoaderJobBox;
