export interface TLoadingBlock {
    line?: number;
}

const LoaderLine = ({ line = 1 }: TLoadingBlock) => {
    return (
        <div className="grid gap-4 loader-job-line">
            {[...Array(line === 0 ? 1 : line)].map((e, i) => (
                <div
                    key={i}
                    className="h-2 bg-border-mid rounded animate-pulse loader-line"
                ></div>
            ))}
        </div>
    );
};

export default LoaderLine;
