export interface TLoadingBlock {
    block?: number;
}

export default function LoadingBox({ block = 1 }: TLoadingBlock) {
    return (
        <div className="bg-white shadow-xs rounded px-5 py-5">
            <div className="flex items-center justify-between gap-4 py-4">
                <div className="h-2.5 w-[50px] bg-border-mid rounded-xsm"></div>
                <div className="flex-1 h-2.5 bg-border-mid rounded-xsm"></div>
                <div className="h-2.5 w-36 bg-border-mid rounded-xsm"></div>
                <div className="h-2.5 w-36 bg-border-mid rounded-xsm"></div>
            </div>
            {[...Array(block === 0 ? 1 : block)].map((e, i) => (
                <div
                    className="animate-pulse border-b border-background"
                    key={i}
                >
                    <div className="flex items-center justify-between gap-4 py-4">
                        <div className="h-[50px] w-[50px] bg-border-mid rounded-full"></div>
                        <div className="flex-1 h-2.5 bg-border-mid rounded-xsm"></div>
                        <div className="h-2.5 w-36 bg-border-mid rounded-xsm"></div>
                        <div className="h-2.5 w-36 bg-border-mid rounded-xsm"></div>
                    </div>
                </div>
            ))}
        </div>
    );
}
