/**
 * External dependencies
 */
import { useSelect } from '@wordpress/data';

/**
 * Internal dependencies.
 */
import Modal from './Modal';
import { Input } from '../form/Input';
import generalSettings from '../../data/general-settings';

type Props = {
    isModalOpen: boolean;
    isModalClose: () => void;
    onSubmit: (val: any) => void;
    commentValue: string;
    inputError: string;
    onChange: (val: any) => void;
};

const ApplicationCommentModal = ({
    isModalOpen,
    isModalClose,
    onSubmit = () => {},
    commentValue = '',
    inputError = '',
    onChange = () => {},
}: Props) => {
    const getUser: object = useSelect(
        (select) => select(generalSettings).getCurrentUser(),
        []
    );
    return (
        <Modal
            isOpen={isModalOpen}
            closeModal={isModalClose}
            areaClass="max-w-[600px] relative"
        >
            <>
                <button
                    onClick={isModalClose}
                    className="flex items-center justify-center absolute top-5 right-5 border-none  text-border-dark leading-[1] transition
                    hover:text-primary focus-visible:outline-0"
                >
                    <i className="tio-clear"></i>
                </button>
                <h4 className="border-b border-border-mid pb-5">
                    Write a comment
                </h4>
                <div className="flex items-start gap-2.5">
                    {getUser?.avatar_url && (
                        <img
                            className="object-cover w-10 h-10 mt-0 rounded-full"
                            src={getUser?.avatar_url}
                            alt={getUser?.display_name}
                        />
                    )}
                    <form onSubmit={(e) => onSubmit(e)}>
                        <Input
                            type="textarea"
                            name="comment"
                            placeholder="Write your message here..."
                            className="h-[100px] focus:ring-0 focus:shadow-none focus:border-border-mid"
                            value={commentValue}
                            onChange={(text) => onChange(text.value)}
                            errorMessage={inputError}
                        />
                        <div className="text-right mt-2.5">
                            <button
                                type="submit"
                                className="inline-flex items-center gap-2 px-4 py-1.5 rounded-sm bg-secondary text-[14px] text-white"
                            >
                                <i className="tio-telegram"></i> Sumbit
                            </button>
                        </div>
                    </form>
                </div>
            </>
        </Modal>
    );
};

export default ApplicationCommentModal;
