/**
 * External dependencies
 */
import { Worker, Viewer } from '@react-pdf-viewer/core';

import '@react-pdf-viewer/core/lib/styles/index.css';
import '@react-pdf-viewer/default-layout/lib/styles/index.css';

/**
 * Internal dependencies.
 */
import Modal from './Modal';

type Props = {
    pdfSrc: string;
    isPdfViewModalOpen: boolean;
    closePdfViewModal: () => void;
};

const PdfViewer = ({pdfSrc = '', isPdfViewModalOpen = false, closePdfViewModal}: Props) => {
    return (
        <Modal
            isOpen={isPdfViewModalOpen}
            closeModal={closePdfViewModal}
            areaClass="max-w-[1200px] !p-0 mt-[50px]"
            zindex="z-20"
        >
            <div className="py-14 px-10 relative">
                <div className="flex items-center justify-between gap-5 pb-5 mb-5 border-b border-border-mid">
                    <h2 className="mb-0">Resume Of Applicant</h2>
                    <button
                        onClick={closePdfViewModal}
                        className="absolute top-[10px] right-[20px] text-border-dark text-[22px]"
                        >
                        <i className="tio-clear"></i>
                    </button>
                </div>
                <Worker workerUrl={`https://unpkg.com/pdfjs-dist@3.11.174/build/pdf.worker.min.js`}>
                    <div style={{ height: '700px' }}>
                        <Viewer fileUrl={pdfSrc} />
                    </div>
                </Worker>
            </div>
        </Modal>
    );
}

export default PdfViewer;