type Props = {
    leftItem?: React.ReactNode;
    rightItem?: React.ReactNode;
    filterItem?: React.ReactNode;
    areaClass?: React.CSSProperties['className'];
};

const FilterBar = ({
    leftItem,
    rightItem,
    filterItem,
    areaClass = '',
}: Props) => {
    return (
        <div className={`${areaClass} bg-white p-[15px] rounded mb-2.5`}>
            <div className="flex items-center justify-between">
                <div className="flex items-center gap-2.5">{leftItem}</div>
                <div className="flex items-center gap-2.5">{rightItem}</div>
            </div>
            {filterItem}
        </div>
    );
};

export default FilterBar;
