/**
 * External dependencies.
 */
import { createReduxStore } from '@wordpress/data';

/**
 * Internal dependencies.
 */
import reducer from './reducer';
import actions from './actions';
import selectors from './selector';
import controls from './controls';
import resolvers from './resolvers';

const careerStore = createReduxStore('ai-job-listing/careers', {
    reducer,
    actions,
    selectors,
    controls,
    resolvers,
});

export default careerStore;
