/**
 * Internal dependencies.
 */
import { DEFAULT_STATE } from './state';
import * as Types from '../types';

const reducer = (state = DEFAULT_STATE, action: any) => {
    switch (action.type) {
        case Types.SET_CAREER_JOBS:
            return {
                ...state,
                jobs: action.jobs,
            };
        case Types.SET_CAREER_JOBS_LOADING:
            return {
                ...state,
                jobsLoading: action.jobsLoading,
            };
        case Types.SET_CAREER_JOBS_TOTAL:
            return {
                ...state,
                jobsTotalCount: action.jobsTotalCount,
            };
        case Types.SET_CAREER_JOBS_TOTAL_PAGE:
            return {
                ...state,
                jobsTotalPage: action.jobsTotalPage,
            };
        case Types.SET_CV_POST_FORM:
            return {
                ...state,
                cvPostForm: action.cvPostForm,
            };
        case Types.SET_CV_POST_FORM_FIELDS:
            return {
                ...state,
                cvPostFormFields: action.cvPostFormFields,
            };
        case Types.SET_CV_FORM_STEP:
            return {
                ...state,
                cvFormStep: action.cvFormStep,
            };
        case Types.SET_CV_FORM_STEP_COMPLETED:
            return {
                ...state,
                cvFormStepCompleted: action.cvFormStepCompleted,
            };
        case Types.SET_CV_FORM_LOADING:
            return {
                ...state,
                cvFormLoading: action.cvFormLoading,
            };
        case Types.SET_SIDEBAR_FILTER_DATA:
            return {
                ...state,
                sidebarFilterData: action.sidebarFilterData,
            };
        case Types.SIDEBAR_FILTER_LOADING:
            return {
                ...state,
                sidebarFilterLoading: action.sidebarFilterLoading,
            };
        case Types.SET_CAREER_PAGE_SETTINGS:
            return {
                ...state,
                careerPageSettings: action.careerPageSettings,
            };
        case Types.SET_CAREER_PAGE_SETTINGS_LOADING:
            return {
                ...state,
                careerPageSettingsLoading: action.careerPageSettingsLoading,
            };
    }

    return state;
};

export default reducer;
