/**
 * Internal dependencies.
 */
import actions from './actions';
import {
    jobApplicationFieldEndpoint,
    attributeValueJobCountsFrontendEndpoint,
    jobsFrontendEndpoint,
    generalSettingsfrontendEndpoint,
} from '../endpoint';
import { IResponseGenerator } from '../../interfaces';

const resolvers = {
    *getJobs(filters: any) {
        if (filters === undefined) {
            filters = {};
        }
        const params = new URLSearchParams(
            filters as URLSearchParams
        ).toString();

        try {
            yield actions.setJobsLoading(true);
            const response: IResponseGenerator =
                yield actions.fetchFromAPIUnparsed(`${jobsFrontendEndpoint}?${params}`);
            let totalCount = 0;
            let totalPage = 0;
            if (response.headers !== undefined) {
                totalPage = response.headers.get('X-WP-TotalPages');
                totalCount = response.headers.get('X-WP-Total');
            }

            // console.log(totalCount);
            yield actions.setJobsTotalCount(totalCount);
            yield actions.setJobsTotalPage(totalPage);
            yield actions.setJobs(response.data);
            yield actions.setJobsLoading(false);
            return response.data;
        } catch (error) {
            // eslint-disable-next-line no-console
            console.error('Error Fetching Job List', error);
        }
    },

    *getCvPostFormFields() {
        try {
            yield actions.setCvFormLoading(true);
            const response = yield actions.fetchFromAPI(
                jobApplicationFieldEndpoint
            );
            if (response) {
                yield actions.setCvPostFormFields(response);
                yield actions.setCvFormLoading(false);
            }
            yield actions.setCvFormLoading(false);
        } catch (error) {
            // eslint-disable-next-line no-console
            console.error('Error Fetching CV Form Fields', error);
        }
    },

    *getSidebarFilterData() {
        try {
            yield actions.setSidebarFilterLoading(true);
            const path = attributeValueJobCountsFrontendEndpoint;
            const response = yield actions.fetchFromAPI(path);

            if (response) {
                const getAllDepartment = response.filter(
                    (department: any) =>
                        department.attribute_slug === 'job-departments'
                );
                const getAllJobTypes = response.filter(
                    (department: any) =>
                        department.attribute_slug === 'job-types'
                );
                const getAllJobShift = response.filter(
                    (department: any) =>
                        department.attribute_slug === 'job-shifts'
                );
                const getAllJobLocation = response.filter(
                    (department: any) =>
                        department.attribute_slug === 'job-locations'
                );
                const settings: any = {
                    jobTypes: [
                        {
                            attribute_value_id: '',
                            attribute_value: 'All',
                            attribute_slug: 'job-types',
                            id: '',
                        },
                        ...getAllJobTypes,
                    ],
                    jobShifts: [
                        {
                            attribute_value_id: '',
                            attribute_value: 'All',
                            attribute_slug: 'job-shifts',
                            id: '',
                        },
                        ...getAllJobShift,
                    ],
                    departments: [
                        {
                            attribute_value_id: '',
                            attribute_value: 'All',
                            attribute_slug: 'job-departments',
                            id: '',
                        },
                        ...getAllDepartment,
                    ],
                    locations: [
                        {
                            attribute_value_id: '',
                            attribute_value: 'All',
                            attribute_slug: 'job-locations',
                            id: '',
                        },
                        ...getAllJobLocation,
                    ],
                };
                yield actions.setSidebarFilterData(settings);
            }
            yield actions.setSidebarFilterLoading(false);
        } catch (error) {
            // eslint-disable-next-line no-console
            console.error('Error Listing Sidebar Data', error);
        }
    },

    *getCareerPageSettings() {
        try {
            yield actions.setCareerPageSettingsLoading(true);
            const response = yield actions.fetchFromAPIUnparsed(generalSettingsfrontendEndpoint);
            if (response.data) {
                yield actions.setCareerPageSettings({
                    ...response.data,
                    posts_per_page: 10,
                    _wpnonce: response.headers.get('x-wp-nonce'),
                });
            }
            yield actions.setCareerPageSettingsLoading(false);
        } catch (error) {
            yield actions.setCareerPageSettingsLoading(false);
            // eslint-disable-next-line no-console
            console.error('Error Fetching Settings', error);
        }
    },
};

export default resolvers;
