/**
 * Internal dependencies.
 */
import { DEFAULT_STATE } from './state';
import * as Types from '../types';

const reducer = (state = DEFAULT_STATE, action: any) => {
    switch (action.type) {
        case Types.SET_GENERAL_SETTINGS_FIELD:
            return {
                ...state,
                generalSettingsField: action.generalSettingsField,
            };
        case Types.SET_GENERAL_SETTINGS:
            return {
                ...state,
                generalSettings: action.generalSettings,
            };
        case Types.SET_GENERAL_SETTINGS_LOADING:
            return {
                ...state,
                generalSettingsLoading: action.generalSettingsLoading,
            };
        case Types.SET_GENERAL_SETTING_SAVE_LOADING:
            return {
                ...state,
                generalSettingSaveLoading: action.generalSettingSaveLoading,
            };
        case Types.SET_EMAIL_TEMPLATES:
            return {
                ...state,
                emailTemplates: action.emailTemplates,
            };
        case Types.SET_EMAIL_TEMPLATES_LOADING:
            return {
                ...state,
                emailTemplatesLoading: action.emailTemplatesLoading,
            };
        case Types.SET_EMAIL_TEMPLATE_DETAILS_LOADING:
            return {
                ...state,
                emailTemplateDetailsLoading: action.emailTemplateDetailsLoading,
            };
        case Types.SET_EMAIL_TEMPLATE_SAVE_LOADING:
            return {
                ...state,
                emailTemplateSaveLoading: action.emailTemplateSaveLoading,
            };
        case Types.SET_CURRENT_USER:
            return {
                ...state,
                currentUser: action.currentUser,
            };
    }

    return state;
};

export default reducer;
