/**
 * Internal dependencies.
 */
import {
    generalSettingsEndpoint,
    generalSettingEndpoint,
    emailTypesEndpoint,
    userEndpoint,
} from '../endpoint';
import actions from './actions';

const resolvers = {
    *getGeneralSettingsField() {
        try {
            yield actions.setGeneralSettingsLoading(true);
            const response = yield actions.fetchFromAPI(
                generalSettingsEndpoint
            );
            if (response) {
                yield actions.setGeneralSettingsField(response);
            }
            yield actions.setGeneralSettingsLoading(false);
        } catch (error) {
            yield actions.setGeneralSettingsLoading(false);
            // eslint-disable-next-line no-console
            console.error('Error Fetching Global Settings Field', error);
        }
    },
    *getGeneralSettings() {
        try {
            yield actions.setGeneralSettingsLoading(true);
            const response = yield actions.fetchFromAPIUnparsed(generalSettingEndpoint);
            if (response.data) {
                yield actions.setGeneralSettings({
                    ...response.data,
                    posts_per_page: 10,
                });
            }
            yield actions.setGeneralSettingsLoading(false);
        } catch (error) {
            yield actions.setGeneralSettingsLoading(false);
            // eslint-disable-next-line no-console
            console.error('Error Fetching Global Settings', error);
        }
    },

    *getEmailTemplates() {
        yield actions.setEmailTemplatesLoading(true);
        const response = yield actions.fetchFromAPI(emailTypesEndpoint);
        yield actions.setEmailTemplates(response);
        yield actions.setEmailTemplatesLoading(false);
    },
    *getCurrentUser() {
        try {
            const response = yield actions.fetchFromAPI(userEndpoint);
            if (response) {
                yield actions.setCurrentUser(response);
            }
        } catch (error) {
            // eslint-disable-next-line no-console
            console.error('Error Fetching User Information', error);
        }
    },
};

export default resolvers;
