/**
 * Internal dependencies.
 */
import { DEFAULT_STATE } from './state';
import * as Types from '../types';

const reducer = (state = DEFAULT_STATE, action: any) => {
    switch (action.type) {
        case Types.SET_JOB_POST_FORM:
            return {
                ...state,
                jobPostForm: action.jobPostForm,
            };
        case Types.SET_JOB_AI_DESCRIPTION:
            return {
                ...state,
                jobAiDescription: action.jobAiDescription,
            };
        case Types.SET_JOB_AI_DESCRIPTION_LOADING:
            return {
                ...state,
                jobAiDescriptionLoading: action.jobAiDescriptionLoading,
            };
        case Types.SET_JOB_POST_FORM_LOADING:
            return {
                ...state,
                jobPostFormLoading: action.jobPostFormLoading,
            };
        case Types.SET_JOB_POST_FORM_ERROR:
            return {
                ...state,
                jobPostFormError: action.jobPostFormError,
            };
        case Types.SET_JOB_FORM_STEP:
            return {
                ...state,
                jobFormStep: action.jobFormStep,
            };
        case Types.SET_JOB_FORM_STEP_COMPLETED:
            return {
                ...state,
                jobFormStepCompleted: action.jobFormStepCompleted,
            };
        case Types.SET_JOB_LISTS:
            return {
                ...state,
                jobLists: action.jobLists,
            };
        case Types.SET_JOB:
            return {
                ...state,
                job: action.job,
            };
        case Types.SET_AXILWEB_AJL_JOB_LIMIT:
            return {
                ...state,
                hasJobLimit: action.hasJobLimit,
            };

        case Types.SET_JOB_STATUS_COUNT:
            return {
                ...state,
                jobStatusCount: action.jobStatusCount,
            };
        case Types.SET_JOB_LISTS_LOADING:
            return {
                ...state,
                jobListsLoading: action.jobListsLoading,
            };
        case Types.SET_JOB_DETAILS_LOADING:
            return {
                ...state,
                jobDetailsLoading: action.jobDetailsLoading,
            };
        case Types.SET_JOB_LISTS_TOTAL_COUNT:
            return {
                ...state,
                jobListsTotalCount: action.jobListsTotalCount,
            };
        case Types.SET_JOB_LISTS_TOTAL_PAGES:
            return {
                ...state,
                jobListsTotalPages: action.jobListsTotalPages,
            };
        case Types.SET_JOB_APPLICATION_LIST:
            return {
                ...state,
                jobApplicationList: action.jobApplicationList,
            };
        case Types.SET_JOB_APPLICATION_STATUS_COUNT:
            return {
                ...state,
                jobApplicationStatusCount: action.jobApplicationStatusCount,
            };
        case Types.SET_JOB_APPLICATION_LOADING:
            return {
                ...state,
                jobApplicationLoading: action.jobApplicationLoading,
            };
        case Types.SET_JOB_APPLICATION_TOTAL_COUNT:
            return {
                ...state,
                jobApplicationTotalCount: action.jobApplicationTotalCount,
            };
        case Types.SET_JOB_APPLICATION_TOTAL_PAGE:
            return {
                ...state,
                jobApplicationTotalPage: action.jobApplicationTotalPage,
            };
        case Types.SET_JOB_APPLICATION:
            return {
                ...state,
                jobApplication: action.jobApplication,
            };
        case Types.SET_JOB_APPLICATION_DETAILS_LOADING:
            return {
                ...state,
                jobApplicationDetailsLoading:
                    action.jobApplicationDetailsLoading,
            };
        case Types.SET_APPLICATION_COMMENTS:
            return {
                ...state,
                jobApplicationComments: action.jobApplicationComments,
            };
        case Types.SET_APPLICATION_COMMENTS_LOADING:
            return {
                ...state,
                jobApplicationCommentsLoading:
                    action.jobApplicationCommentsLoading,
            };
        case Types.SET_APPLICATION_COMMENT_COUNTS:
            return {
                ...state,
                jobApplicationCommentCounts: action.jobApplicationCommentCounts,
            };
        case Types.SET_APPLICATION_COMMENT_PAGES:
            return {
                ...state,
                jobApplicationCommentPages: action.jobApplicationCommentPages,
            };
        case Types.SET_JOB_APPLICATION_DATES:
            return {
                ...state,
                jobApplicationDates: action.jobApplicationDates,
            };
        case Types.SET_JOB_APPLICATION_DATES_LOADING:
            return {
                ...state,
                jobApplicationDatesLoading: action.jobApplicationDatesLoading,
            };
        case Types.SET_USERS_EMAIL_LISTS:
            return {
                ...state,
                usersEmailList: action.usersEmailList,
            };
        case Types.SET_MAIL_NOTIFICATION_USERS_BY_JOB:
            return {
                ...state,
                mailNotificationUsersByJob: action.mailNotificationUsersByJob,
            };
        case Types.SET_LOADING_MAIL_NOTIFICATION_USERS:
            return {
                ...state,
                loadingMailNotificationUsers:
                    action.loadingMailNotificationUsers,
            };
        case Types.SET_JOB_OVERVIEW_STATUS:
            return {
                ...state,
                jobOverviewStatus:
                    action.jobOverviewStatus,
            };
        case Types.SET_JOB_OVERVIEW_STATUS_LOADING:
            return {
                ...state,
                jobOverviewStatusLoading:
                    action.jobOverviewStatusLoading,
            };
    }

    return state;
};

export default reducer;
