/**
 * Internal dependencies.
 */
import actions from './actions';
import {
    jobsEndpoint,
    jobStatusCountEndpoint,
    jobsApplicationEndpoint,
    jobsApplicationStatusCountEndpoint,
    processCommentUpdateEndpoint,
    hasJobLimitEndpoint,
    allUsersWithRolesEndpoint,
    listOfUsersByJobIdEndpoint,
    jobOverviewStatusEndpoint
} from '../endpoint';
import { IResponseGenerator } from '../../interfaces';

const resolvers = {
    *getHasJobLimit() {
        const response = yield actions.fetchFromAPIUnparsed(
            hasJobLimitEndpoint
        );
        yield actions.setHasJobLimit(response.data);
    },
    *getJobLists(filters: any) {
        if (filters === undefined) {
            filters = {};
        }
        const params = new URLSearchParams(
            filters as URLSearchParams
        ).toString();

        try {
            yield actions.setJobListsLoading(true);
            const response: IResponseGenerator =
                yield actions.fetchFromAPIUnparsed(`${jobsEndpoint}?${params}`);
            let totalCount = 0;
            let totalPage = 0;
            if (response.headers !== undefined) {
                totalPage = response.headers.get('X-WP-TotalPages');
                totalCount = response.headers.get('X-WP-Total');
            }

            // console.log(totalCount);
            yield actions.setJobListsTotalCount(totalCount);
            yield actions.setJobListsTotalPages(totalPage);
            yield actions.setJobLists(response.data);
            yield actions.setJobListsLoading(false);
            return response.data;
        } catch (error) {
            // eslint-disable-next-line no-console
            console.error('Error Fetching Job List', error);
        }
    },
    *getJob(payload: any) {
        if (payload === undefined) {
            payload = {};
        }
        const params = new URLSearchParams(
            payload as URLSearchParams
        ).toString();
        try {
            yield actions.setJobDetailsLoading(true);
            const path = `${jobsEndpoint}?${params}`;
            const response = yield actions.fetchFromAPI(path);
            const responseData = response[0];

            if (responseData?.id == payload.id) {
                yield actions.setJob({
                    ...responseData,
                });
            }
            yield actions.setJobDetailsLoading(false);
        } catch (error) {
            console.error('Error fetching Job Details:', error);
        }
    },
    *getJobStatusCount() {
        try {
            const path = jobStatusCountEndpoint;
            const response = yield actions.fetchFromAPI(path);

            if (response) {
                yield actions.setJobStatusCount(response);
            }
        } catch (error) {
            console.error('Error fetching Job Status Count:', error);
        }
    },
    *getJobApplicationList(filters: any) {
        if (filters === undefined) {
            filters = {};
        }
        const params = new URLSearchParams(
            filters as URLSearchParams
        ).toString();

        try {
            yield actions.setJobApplicationLoading(true);
            const response: IResponseGenerator =
                yield actions.fetchFromAPIUnparsed(
                    `${jobsApplicationEndpoint}?${params}`
                );
            let totalCount = 0;
            let totalPage = 0;
            if (response.headers !== undefined) {
                totalPage = response.headers.get('X-WP-TotalPages');
                totalCount = response.headers.get('X-WP-Total');
            }

            yield actions.setJobApplicationTotalCount(totalCount);
            yield actions.setJobApplicationTotalPage(totalPage);
            yield actions.setJobApplicationList(response.data);
            yield actions.setJobApplicationLoading(false);
        } catch (error) {
            // eslint-disable-next-line no-console
            console.error('Error Fetching Job Application', error);
        }
    },
    *getJobApplicationStatusCount(filters: any) {
        if (filters === undefined) {
            filters = {};
        }
        const params = new URLSearchParams(
            filters as URLSearchParams
        ).toString();
        try {
            yield actions.setJobApplicationLoading(true);
            const response: any = yield actions.fetchFromAPI(
                `${jobsApplicationStatusCountEndpoint}?${params}`
            );
            if (response) {
                yield actions.setJobApplicationStatusCount(response);
            }
            yield actions.setJobApplicationLoading(false);
        } catch (error) {
            console.error(
                'Error fetching Job Application Status Count:',
                error
            );
        }
    },
    *getJobApplication(payload: any) {
        if (payload === undefined) {
            payload = {};
        }
        const params = new URLSearchParams(
            payload as URLSearchParams
        ).toString();

        try {
            yield actions.setJobApplicationDetailsLoading(true);
            const response: any = yield actions.fetchFromAPI(
                `${jobsApplicationEndpoint}?${params}`
            );
            const responseData = response[0];
            if (responseData?.id == payload.id) {
                yield actions.setJobApplication({
                    ...responseData,
                });
            }
            yield actions.setJobApplicationDetailsLoading(false);
        } catch (error) {
            // eslint-disable-next-line no-console
            console.error('Error Fetching Job Application Details', error);
        }
    },
    *getApplicationComments(filters: any) {
        if (filters === undefined) {
            filters = {};
        }
        const params = new URLSearchParams(
            filters as URLSearchParams
        ).toString();

        try {
            yield actions.setApplicationCommentsLoading(true);
            const response: IResponseGenerator =
                yield actions.fetchFromAPIUnparsed(
                    `${processCommentUpdateEndpoint}?${params}`
                );
            let totalCount = 0;
            let totalPage = 0;
            if (response.headers !== undefined) {
                totalPage = response.headers.get('X-WP-TotalPages');
                totalCount = response.headers.get('X-WP-Total');
            }

            // console.log(totalCount);
            yield actions.setApplicationCommentCounts(totalCount);
            yield actions.setApplicationCommentPages(totalPage);
            yield actions.setApplicationComments(response.data);
            yield actions.setApplicationCommentsLoading(false);
        } catch (error) {
            // eslint-disable-next-line no-console
            console.error('Error Fetching Comments', error);
        }
    },
    *getUsersEmailList(filters: any) {
        if (filters === undefined) {
            filters = {};
        }
        const params = new URLSearchParams(
            filters as URLSearchParams
        ).toString();
        try {
            const response: any = yield actions.fetchFromAPI(
                `${allUsersWithRolesEndpoint}?${params}`
            );
            // console.log(response);
            if (response) {
                const prepareForSelectbox = response.map((user: any) => {
                    return {
                        label: user.email,
                        value: user.email,
                    };
                });
                yield actions.setUsersEmailList(prepareForSelectbox);
            }
        } catch (error) {
            console.error('Error fetching Users email', error);
        }
    },
    *getMailNotificationUsersByJob(id: any) {
        yield actions.setLoadingMailNotificationUsers(true);
        try {
            const response: any = yield actions.fetchFromAPI(
                `${listOfUsersByJobIdEndpoint}/${id}`
            );

            if (response) {
                yield actions.setMailNotificationUsersByJob(response);
            }
            yield actions.setLoadingMailNotificationUsers(false);
        } catch (error) {
            yield actions.setLoadingMailNotificationUsers(false);
            console.error('Error fetching Users', error);
        }
    },
    *getJobOverviewStatus() {
        yield actions.setJobOverviewStatusLoading(true);
        try {
            const path = jobOverviewStatusEndpoint;
            const response = yield actions.fetchFromAPI(path);
            if (response) {
                yield actions.setJobOverviewStatus(response);
            }
            yield actions.setJobOverviewStatusLoading(false);
            return response;
        } catch (error) {
            yield actions.setJobOverviewStatusLoading(false);
            console.error('Error fetching Job Status Count:', error);
        }
    },

};

export default resolvers;
