/**
 * Internal dependencies.
 */
import { IJob } from './state';

const selectors = {
    getJobPostForm(state: IJob) {
        const { jobPostForm } = state;

        return jobPostForm;
    },
    getJobAiDescription(state: IJob) {
        return state.jobAiDescription;
    },
    getJobAiDescriptionLoading(state: IJob) {
        return state.jobAiDescriptionLoading;
    },
    getJobPostFormLoading(state: IJob) {
        const { jobPostFormLoading } = state;

        return jobPostFormLoading;
    },
    getJobPostFormError(state: IJob) {
        const { jobPostFormError } = state;

        return jobPostFormError;
    },
    getJobFormStep(state: IJob) {
        const { jobFormStep } = state;

        return jobFormStep;
    },
    getJobFormStepCompleted(state: IJob) {
        const { jobFormStepCompleted } = state;

        return jobFormStepCompleted;
    },
    getJobLists(state: IJob) {
        const { jobLists } = state;

        return jobLists;
    },
    getJobListsLoading(state: IJob) {
        const { jobListsLoading } = state;

        return jobListsLoading;
    },
    getJobDetailsLoading(state: IJob) {
        const { jobDetailsLoading } = state;

        return jobDetailsLoading;
    },
    getJobListsTotalCount(state: IJob) {
        const { jobListsTotalCount } = state;

        return jobListsTotalCount;
    },
    getJobListsTotalPages(state: IJob) {
        const { jobListsTotalPages } = state;

        return jobListsTotalPages;
    },
    getJob(state: IJob) {
        const { job } = state;

        return job;
    },
    getHasJobLimit(state: IJob) {
        const { hasJobLimit } = state;
        return hasJobLimit;
    },

    getJobStatusCount(state: IJob) {
        const { jobStatusCount } = state;

        return jobStatusCount;
    },
    getJobApplicationList(state: IJob) {
        const { jobApplicationList } = state;

        return jobApplicationList;
    },
    getJobApplicationStatusCount(state: IJob) {
        const { jobApplicationStatusCount } = state;

        return jobApplicationStatusCount;
    },
    getJobApplicationLoading(state: IJob) {
        const { jobApplicationLoading } = state;

        return jobApplicationLoading;
    },
    getJobApplicationTotalCount(state: IJob) {
        const { jobApplicationTotalCount } = state;

        return jobApplicationTotalCount;
    },
    getJobApplicationTotalPage(state: IJob) {
        const { jobApplicationTotalPage } = state;

        return jobApplicationTotalPage;
    },
    getJobApplication(state: IJob) {
        const { jobApplication } = state;

        return jobApplication;
    },
    getJobApplicationDetailsLoading(state: IJob) {
        const { jobApplicationDetailsLoading } = state;

        return jobApplicationDetailsLoading;
    },
    getApplicationComments(state: IJob) {
        const { jobApplicationComments } = state;

        return jobApplicationComments;
    },
    getApplicationCommentsLoading(state: IJob) {
        const { jobApplicationCommentsLoading } = state;

        return jobApplicationCommentsLoading;
    },
    getApplicationCommentCounts(state: IJob) {
        const { jobApplicationCommentCounts } = state;

        return jobApplicationCommentCounts;
    },
    getApplicationCommentPages(state: IJob) {
        const { jobApplicationCommentPages } = state;

        return jobApplicationCommentPages;
    },
    getJobApplicationDates(state: IJob) {
        const { jobApplicationDates } = state;

        return jobApplicationDates;
    },
    getJobApplicationDatesLoading(state: IJob) {
        const { jobApplicationDatesLoading } = state;

        return jobApplicationDatesLoading;
    },
    getUsersEmailList(state: IJob) {
        const { usersEmailList } = state;

        return usersEmailList;
    },
    getMailNotificationUsersByJob(state: IJob) {
        const { mailNotificationUsersByJob } = state;

        return mailNotificationUsersByJob;
    },
    getLoadingMailNotificationUsers(state: IJob) {
        const { loadingMailNotificationUsers } = state;

        return loadingMailNotificationUsers;
    },
    getJobOverviewStatus(state: IJob) {
        const { jobOverviewStatus } = state;

        return jobOverviewStatus;
    },
    getJobOverviewStatusLoading(state: IJob) {
        const { jobOverviewStatusLoading } = state;

        return jobOverviewStatusLoading;
    },
};

export default selectors;
