export interface IJobPostForm {
    id: number | null;
    title: string | null;
    application_deadline: string | null;
    job_departments: number | null;
    job_types: number | null;
    job_shifts: number | null;
    job_locations: number | null;
    job_education_qualifications: number | null;
    job_application_method: number | null;
    job_salary_type: number | null;
    no_of_vacancies: number | null;
    is_required_cv_photo: string | null;
    description: string | null;
    min_salary: number;
    max_salary: number;
    responsibilities: string | null;
    benefits: string | null;
    requirements: string | null;
    experienced_year: number | string | null;
    additional_requirements?: string | null;
    additional_notes?: string | null;
    seo_title: string | null;
    seo_description: string | null;
    feature_image: string | null;
    form_step_complete: number | null;
    status: string | null;
}

export interface IJob {
    jobPostForm: IJobPostForm;
    jobFormStep: number;
    jobFormStepCompleted: number;
    jobPostFormLoading: boolean;
    jobPostFormError: boolean;
    jobLists: Array<any>;
    job: object;
    jobListsLoading: boolean;
    jobDetailsLoading: boolean;
    jobListsTotalCount: number;
    jobListsTotalPages: number;
    jobStatusCount: Array<any>;
    jobApplicationList: Array<any>;
    jobApplicationStatusCount: Array<any>;
    jobApplicationLoading: boolean;
    jobApplicationTotalCount: number;
    jobApplicationTotalPage: number;
    jobApplication: object;
    jobApplicationDetailsLoading: boolean;
    jobApplicationComments: Array<any>;
    jobApplicationCommentsLoading: boolean;
    jobApplicationCommentCounts: number;
    jobApplicationCommentPages: number;
    hasJobLimit: boolean;
    jobAiDescription: string;
    jobAiDescriptionLoading: boolean;
    jobApplicationDates: Array<any>;
    jobApplicationDatesLoading: boolean;
    usersEmailList: Array<any>;
    mailNotificationUsersByJob: Array<any>;
    loadingMailNotificationUsers: boolean;
    jobOverviewStatusLoading: boolean;
    jobOverviewStatus: object;
}

export const defaultJobPostForm = {
    id: null,
    title: null,
    application_deadline: null,
    job_departments: null,
    job_types: null,
    job_shifts: null,
    job_locations: null,
    job_education_qualifications: null,
    job_application_method: null,
    job_salary_type: null,
    no_of_vacancies: null,
    is_required_cv_photo: null,
    description: '',
    min_salary: 0,
    max_salary: 0,
    responsibilities: '',
    benefits: '',
    requirements: '',
    experienced_year: null,
    additional_requirements: '',
    additional_notes: '',
    seo_title: null,
    seo_description: '',
    feature_image: null,
    form_step_complete: 1,
    status: 'draft',
};

export const DEFAULT_STATE: IJob = {
    jobPostForm: {
        ...defaultJobPostForm,
    },
    jobPostFormLoading: false,
    jobPostFormError: false,
    jobFormStep: 1,
    jobFormStepCompleted: 1,
    jobLists: [],
    job: {},
    jobListsLoading: false,
    jobDetailsLoading: false,
    jobListsTotalCount: 0,
    jobListsTotalPages: 0,
    jobStatusCount: [],
    jobApplicationList: [],
    jobApplicationStatusCount: [],
    jobApplicationLoading: false,
    jobApplicationTotalCount: 0,
    jobApplicationTotalPage: 0,
    jobApplication: {},
    jobApplicationDetailsLoading: false,
    jobApplicationComments: [],
    jobApplicationCommentsLoading: false,
    jobApplicationCommentCounts: 0,
    jobApplicationCommentPages: 0,
    hasJobLimit: false,
    jobAiDescription: '',
    jobAiDescriptionLoading: false,
    jobApplicationDates: [],
    jobApplicationDatesLoading: false,
    usersEmailList: [],
    mailNotificationUsersByJob: [],
    loadingMailNotificationUsers: false,
    jobOverviewStatusLoading: false,
    jobOverviewStatus: {},
};
