/**
 * External dependencies.
 */
import { createReduxStore } from '@wordpress/data';

/**
 * Internal dependencies.
 */
import reducer from './reducer';
import actions from './actions';
import selectors from './selector';
import controls from './controls';
import resolvers from './resolvers';

const settingStore = createReduxStore('ai-job-listing/settings', {
    reducer,
    actions,
    selectors,
    controls,
    resolvers,
});

export default settingStore;
