/**
 * Internal dependencies.
 */
import { DEFAULT_STATE } from './state';
import * as Types from '../types';

const reducer = (state = DEFAULT_STATE, action: any) => {
    switch (action.type) {
        case Types.GET_SETTINGS_ATTRIBUTES:
            return {
                ...state,
                settingsAttributes: action.settingsAttributes,
            };
        case Types.SET_LOADING_SETTINGS:
            return {
                ...state,
                loadingSettings: action.loadingSettings,
            };
        case Types.SET_LOADING_SETTINGS_META:
            return {
                ...state,
                loadingSettingsMeta: action.loadingSettingsMeta,
            };
        case Types.GET_SETTINGS_ATTRIBUTE_METAS:
            return {
                ...state,
                settingsAttributeMetas: action.settingsAttributeMetas,
            };
        case Types.SET_SETTINGS_ATTRIBUTE_META_TOTAL:
            return {
                ...state,
                settingsAttributeMetaTotal: action.settingsAttributeMetaTotal,
            };
        case Types.SET_SETTINGS_ATTRIBUTE_META_TOTAL_PAGE:
            return {
                ...state,
                settingsAttributeMetaTotalPage:
                    action.settingsAttributeMetaTotalPage,
            };
        case Types.SET_META_FORM_DATA:
            return {
                ...state,
                settingsMetaForm: action.settingsMetaForm,
            };
        case Types.GET_JOB_SETTINGS:
            return {
                ...state,
                jobSettings: action.jobSettings,
            };
    }

    return state;
};

export default reducer;
