/* eslint-disable no-console */
/**
 * Internal dependencies.
 */
import actions from './actions';
import {
    jobsAttributes,
    jobAttributeMetasEndpoint,
    emailTypesEndpoint,
    emailTemplatesEndpoint,
} from '../endpoint';
import { IResponseGenerator } from '../../interfaces';

const resolvers = {
    *getSettingsAttributes() {
        yield actions.setLoadingSettings(true);
        const response: IResponseGenerator = yield actions.fetchFromAPIUnparsed(
            jobsAttributes
        );
        yield actions.setSettingsAttribute(response.data);
        yield actions.setLoadingSettings(false);
    },
    *getSettingAttributeMetas(filters: any) {
        if (filters === undefined) {
            filters = {};
        }
        const params = new URLSearchParams(
            filters as URLSearchParams
        ).toString();

        try {
            yield actions.setLoadingSettingsMeta(true);
            const path = `${jobAttributeMetasEndpoint}?${params}`;
            const response = yield actions.fetchFromAPI(path);
            if (response) {
                const metaAttributeId = response?.data[0]?.attribute_id;
                const metaAttributeLabel =
                    response?.data[0]?.attribute_slug?.name;
                const responsData = {
                    ...response,
                    metaAttributeId,
                    metaAttributeLabel,
                };
                yield actions.setSettingAttributeMetas(responsData);
                yield actions.setLoadingSettingsMeta(false);
            }
        } catch (error) {
            console.error('Error fetching setting attribute metas:', error);
        }
    },
};

export default resolvers;
