export interface ISettingsAttribute {
    attribute_id: number;
    name: string;
    slug: string;
    label: string;
    menu_orderby: string;
    is_active: string;
}
export interface ISettingsAttributeMetas {
    id: number;
    value: string;
    slug: string;
    attribute_payload: Array<ISettingsAttribute>;
    attribute_id: number;
}
export interface IsettingsMetaForm {
    id: number | null;
    attribute_id: number | null;
    value: string;
}

export interface ISettingsAttributes {
    settingsAttributes: Array<ISettingsAttribute>;
    loadingSettings: boolean;
    loadingSettingsMeta: boolean;
    settingsAttributeMetas: Array<any>;
    settingsMetaForm: IsettingsMetaForm;
    job_attribute_payload: number;
    jobSettings: object;
    settingsAttributeMetaTotal: number | string;
    settingsAttributeMetaTotalPage: number | string;
}
export const settingsMetaDefaultData = {
    id: null,
    attribute_id: null,
    value: '',
};

export const DEFAULT_STATE: ISettingsAttributes = {
    settingsAttributes: [],
    settingsAttributeMetas: [],
    settingsAttributeMetaTotal: 0,
    settingsAttributeMetaTotalPage: 0,
    loadingSettings: false,
    loadingSettingsMeta: false,
    settingsMetaForm: {
        ...settingsMetaDefaultData,
    },
    jobSettings: {},
};
