// Page Title
export interface TPageTitle {
    text: string;
    customClass?: string;
    areaClass?: string;
    areaSpace?: string;
    backButton?: boolean;
}

// Button
export interface TButton {
    text: string | React.ReactNode;
    icon?: string | undefined;
    href?: string;
    externalLink?: boolean;
    type?: 'button' | 'submit' | 'reset';
    btnStyle?: string;
    outline?: boolean;
    buttonCustomClass?: string;
    disabled?: boolean;
    onClick?: (val: any) => void;
    size?: string;
}

// Input
export interface InputType {
    target: any;
    name: string;
    value: any;
}

export interface IResponseGenerator {
    id: number;
    config?: any;
    data?: any;
    headers?: any;
    request?: any;
    response?: any;
    status?: any;
    statusText?: string;
    message?: string;
    form_step_complete: number;
    total: number;
}
