/**
 * Internal dependencies.
 */
import { __ } from '@wordpress/i18n';
import { formatSalaryAmount, getValueByKey } from '../../../../../utils/Global';
import { parseHtml } from '../../../../../utils/ParseHtml';
import { formatDateOnly } from '../../../../../utils/DateHelper';

const JobSummery = ({ getJobDetails = {}, settings = {} }: any) => {
    return (
        <div className="w-full p-[30px] rounded bg-white">
            <h2 className="mb-[30px]">{getJobDetails.title}</h2>
            {getJobDetails?.description && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Job Description', 'ai-job-listing')}</h3>
                    {parseHtml(getJobDetails?.description)}
                </div>
            )}
            {getJobDetails?.responsibilities && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Job Responsibilities', 'ai-job-listing')}</h3>
                    {parseHtml(getJobDetails?.responsibilities)}
                </div>
            )}
            {getJobDetails?.requirements && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Primary Requirements', 'ai-job-listing')}</h3>
                    {parseHtml(getJobDetails?.requirements)}
                </div>
            )}
            {getJobDetails?.experienced_year && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Experience', 'ai-job-listing')}</h3>
                    <div className="text-[17px] text-b1-notice-comment">
                        {getJobDetails?.experienced_year?.value}
                    </div>
                </div>
            )}
            {getJobDetails?.additional_requirements && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Optional/Preferred Requirements', 'ai-job-listing')}</h3>
                    <div className="text-[14px] font-bold">
                    {__('Candidates who meet the following preference.', 'ai-job-listing')} 
                    </div>
                    {parseHtml(getJobDetails?.additional_requirements)}
                </div>
            )}
            {getJobDetails?.benefits && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Benifits', 'ai-job-listing')}</h3>
                    {parseHtml(getJobDetails?.benefits)}
                </div>
            )}
            {getJobDetails?.additional_notes && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Additional Note', 'ai-job-listing')}</h3>
                    {parseHtml(getJobDetails?.additional_notes)}
                </div>
            )}
            {getJobDetails?.attribute_values && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Job Location', 'ai-job-listing')}</h3>
                    <div>
                        {getValueByKey(
                            getJobDetails.attribute_values,
                            'job_locations'
                        )}
                    </div>
                </div>
            )}
            {getJobDetails?.attribute_values && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Educational Requirements', 'ai-job-listing')}</h3>
                    <div>
                        {getValueByKey(
                            getJobDetails.attribute_values,
                            'job_education_qualifications'
                        )}
                    </div>
                </div>
            )}
            {getJobDetails?.no_of_vacancies && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('No. Of Vacancies', 'ai-job-listing')}</h3>
                    <div>{getJobDetails?.no_of_vacancies}</div>
                </div>
            )}
            {getJobDetails?.attribute_values && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Job Type', 'ai-job-listing')}</h3>
                    <div>
                        {getValueByKey(
                            getJobDetails.attribute_values,
                            'job_types'
                        )}
                    </div>
                </div>
            )}
            {getJobDetails?.attribute_values && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Job Department', 'ai-job-listing')}</h3>
                    <div>
                        {getValueByKey(
                            getJobDetails.attribute_values,
                            'job_departments'
                        )}
                    </div>
                </div>
            )}
            {getJobDetails?.min_salary != 0 && getJobDetails?.max_salary != 0 && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Salary Range', 'ai-job-listing')}</h3>
                    <div>
                        {`${settings?.currency_symbol}${formatSalaryAmount(
                            getJobDetails?.min_salary
                        )} - ${settings?.currency_symbol}${formatSalaryAmount(
                            getJobDetails?.max_salary
                        )} (${getValueByKey(
                            getJobDetails.attribute_values,
                            'job_salary_type'
                        )})`}
                    </div>
                </div>
            )}
            {getJobDetails?.is_required_cv_photo === '1' && (
                <div className="mb-[30px]">
                    <h3 className="mb-2.5">{__('Photograph', 'ai-job-listing')}</h3>
                    <ul>
                        <li>{__('Photograph must be enclosed with the resume', 'ai-job-listing')}</li>
                    </ul>
                </div>
            )}
            {getJobDetails?.application_deadline && (
                <div>
                    <h3 className="mb-2.5">{__('Application Deadline', 'ai-job-listing')}</h3>
                    <div>
                        {formatDateOnly(getJobDetails?.application_deadline)}
                    </div>
                </div>
            )}
        </div>
    );
};

export default JobSummery;
