/**
 * External dependencies
 */
import { useEffect } from '@wordpress/element';
import { useSelect, useDispatch } from '@wordpress/data';
import { useParams } from 'react-router-dom';

/**
 * Internal dependencies.
 */
import { __ } from '@wordpress/i18n';
import jobstore from '../../../../data/job';
import PageTitle from '../../../../components/layout/PageTitle';
import FormStepOne from './form-step/FormStepOne';
import FormStepTwo from './form-step/FormStepTwo';
import FormStepThree from './form-step/FormStepThree';
import FormStepFour from './form-step/FormStepFour';
import FormStepFive from './form-step/FormStepFive';
import settingStore from '../../../../data/settings';

const JobCreate = () => {
    const params = useParams();
    const postId = params.id;

    const dispatch = useDispatch();
    const jobFormStep: number = useSelect(
        (select) => select(jobstore).getJobFormStep(),
        []
    );
    const jobFormStepCompleted: number = useSelect(
        (select) => select(jobstore).getJobFormStepCompleted(),
        []
    );

    useEffect(() => {
        if (postId) {
            dispatch(jobstore)
                .getJobPostForm(postId)
                .then((result: any) => {
                    if (Number(result?.form_step_complete) === 5) {
                        dispatch(jobstore).setJobFormStep(1);
                    } else {
                        dispatch(jobstore).setJobFormStep(
                            Number(result?.form_step_complete) + 1
                        );
                    }
                });
        }
        dispatch(settingStore).getJobSettings();
    }, []);

    // Step Control
    const formStepsLabel = [
        {
            step: 1,
            value: __('Job Info', 'ai-job-listing'),
        },
        {
            step: 2,
            value: __('Job Details', 'ai-job-listing'),
        },
        {
            step: 3,
            value: __('Requirements', 'ai-job-listing'),
        },
        {
            step: 4,
            value: __('SEO', 'ai-job-listing'),
        },
        {
            step: 5,
            key: 'preview',
            value: __('Preview', 'ai-job-listing'),
        },
    ];
    const setFormSteps = (step: any) => {
        if (jobFormStepCompleted >= step) {
            dispatch(jobstore).setJobFormStep(step);
        }
    };

    // Step Form Control
    const GetFormStep = () => {
        switch (jobFormStep) {
            case 2:
                return <FormStepTwo />;
                break;
            case 3:
                return <FormStepThree />;
                break;
            case 4:
                return <FormStepFour />;
                break;
            case 5:
                return <FormStepFive />;
                break;
            default:
                return <FormStepOne />;
                break;
        }
    };
    const stepLineStyle =
        'after:h-[2px] after:w-[90%] after:absolute after:bottom-[15px] after:right-0 after:left-0 after:mx-auto after:-z-10';

    return (
        <>
            <PageTitle text="Add New Job Post" backButton />
            <div className="bg-white w-[952px] rounded">
                <div className="bg-lightblue px-[60px] py-[30px] rounded-t">
                    <div className="list-none flex items-center gap-5 justify-between p-0 relative z-10">
                        {formStepsLabel?.map((data) => (
                            <button
                                className={`m-0 p-0 text-center ${stepLineStyle} ${
                                    jobFormStep >= data.step
                                        ? 'after:bg-border-dark'
                                        : 'after:bg-border-dark'
                                }`}
                                key={data.step}
                                onClick={() => setFormSteps(data.step)}
                            >
                                <span
                                    className={`block text-[16px] font-bold mb-[12px] ${
                                        jobFormStep >= data.step
                                            ? 'text-primary'
                                            : 'text-b1-notice-comment'
                                    }`}
                                >
                                    {data.value}
                                </span>
                                <span
                                    className={`flex items-center justify-center h-[30px] w-[30px] mx-auto border-2 
                                 rounded-full text-[15px] font-bold bg-white ${
                                     jobFormStep == data.step &&
                                     'border-primary !text-primary bg-white'
                                 } ${
                                        jobFormStep > data.step
                                            ? 'bg-primary text-primary border-primary'
                                            : 'border-border-dark text-border-dark'
                                    }`}
                                >
                                    {jobFormStep > data.step ? (
                                        <i className="tio-done"></i>
                                    ) : (
                                        data.step
                                    )}
                                </span>
                            </button>
                        ))}
                    </div>
                </div>
                <div className="job-post-form p-[30px] relative min-h-[550px]">
                    {<GetFormStep />}
                </div>
            </div>
        </>
    );
};

export default JobCreate;
