/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { useLocation } from 'react-router-dom';
import { useDispatch } from '@wordpress/data';

/**
 * Internal dependencies.
 */
import jobstore from '../../../../data/job';
import ThankYouImg from '../../../../style/images/thankyou.png';
import Button from '../../../../components/button/Button';
import { defaultJobPostForm } from '../../../../data/job/state';
import { formatDateOnly } from '../../../../utils/DateHelper';
import { getValueByKey } from '../../../../utils/Global';
import { statusElementGenerate } from '../../../../utils/Element';

const JobPostThankYou = () => {
    const dispatch = useDispatch();
    const location = useLocation();
    const jobInfo = location.state || {};

    const siteBasePath = window.location.pathname;
    const pathIndex = siteBasePath.lastIndexOf('wp-admin');
    const livePath = siteBasePath.substring(0, pathIndex);

    return (
        <>
            <div className="p-[50px] max-w-[952px] rounded bg-white text-center">
                <h1 className="text-green mb-10">
                    Congratulations! Your Job Post Is Now Live
                </h1>
                <div className="mb-[30px]">
                    <img
                        src={ThankYouImg}
                        alt="Images"
                        className="mx-auto my-0"
                    />
                </div>
                <h2 className="mb-2.5">
                    {jobInfo?.title && `${jobInfo?.title} Is Now Live`}
                </h2>
                <div className="flex items-center justify-center gap-2.5 mb-[30px]">
                    <div className="flex items-center gap-1 text-[16px] text-b2-table">
                        <span className="flex items-center gap-[5px] text-headline">
                            <i className="tio-briefcase_outlined"></i>
                            Department:
                        </span>
                        <span>
                            {getValueByKey(
                                jobInfo?.attribute_values,
                                'job_departments'
                            )}
                        </span>
                    </div>
                    <div className="flex items-center gap-1 text-[16px] text-b2-table">
                        <span className="flex items-center gap-[5px] text-headline">
                            <i className="tio-calendar"></i>
                            Posted on:
                        </span>
                        <span>{formatDateOnly(jobInfo?.created_at)}</span>
                    </div>
                    <div className="flex items-center gap-1 text-[16px] text-b2-table">
                        <span className="flex items-center gap-[5px] text-headline">
                            <i className="tio-calendar"></i>
                            Deadline:
                        </span>
                        <span>
                            {formatDateOnly(jobInfo?.application_deadline)}
                        </span>
                    </div>
                    {statusElementGenerate('active')}
                </div>
                <div className="flex items-center gap-5 justify-center">
                    <Button 
                        text={__('Go to Job List Page', 'ai-job-listing')}
                        btnStyle="light"
                        size="large"
                        outline
                        href="/"
                        onClick={() => {
                            dispatch(jobstore).setJobPostForm({
                                ...defaultJobPostForm,
                            });
                            dispatch(jobstore).setJobFormStep(1);
                            dispatch(jobstore).setJobFormStepCompleted(1);
                        }}
                    />
                    <Button
                        text={__('View on Live Site', 'ai-job-listing')}
                        btnStyle="secondary"
                        size="large"
                        href={`${livePath}${jobInfo?.liveUrlBase}/${jobInfo?.slug}`}
                        externalLink
                    />
                </div>
            </div>
        </>
    );
};

export default JobPostThankYou;
