/**
 * External dependencies
 */
import { useState, useEffect } from '@wordpress/element';
import { useSelect, useDispatch } from '@wordpress/data';
import { __ } from '@wordpress/i18n';
import { HexColorPicker, HexColorInput } from 'react-colorful';

/**
 * Internal dependencies.
 */
import generalSettings from '../../../../data/general-settings';
import Button from '../../../../components/button/Button';
import { SwalSuccess } from '../../../../utils/Swal';
import SwitchCheckbox from '../../../../components/form/SwitchCheckbox';
import PageTitle from '../../../../components/layout/PageTitle';

import {
    inputStyle,
    selectStylesSM,
} from '../../../../components/form/StyleClass';
import InputLabel from '../../../../components/form/InputLabel';
import LoaderLine from '../../../../components/loader/LoaderLine';
import { Input } from '../../../../components/form/Input';
import { currenciesSymbol, getArrayValueByKey } from '../../../../utils/Global';
const CareerPageSettings = () => {
    const dispatch = useDispatch();
    const [allSettings, setAllSettings] = useState<any>([]);
    const settingsLoading: any = useSelect(
        (select) => select(generalSettings).getGeneralSettingsLoading(),
        []
    );
    const settingSaveLoading: any = useSelect(
        (select) => select(generalSettings).getGeneralSettingSaveLoading(),
        []
    );
    const getSettings: object = useSelect(
        (select) => select(generalSettings).getGeneralSettings(),
        []
    );

    const [settingsField, setSettingsField] = useState<any>([]);
    const [settingValues, setSettingValues] = useState<any>([]);
    const [currencyValue, setCurrencyValue] = useState<any>('$');
    const [colorPickerVisiable, setColorPickerVisiable] = useState<object>({
        visiable: false,
        name: '',
    });
    const [careerPageList, setCareerPageList] = useState<Array<any>>([]);
    const [careerPageSelected, setCareerPageSelected] = useState<any>('');

    useEffect(() => {
        dispatch(generalSettings)
            .getGeneralSettingsField()
            .then((response) => {
                setAllSettings(response);
            });

            // career page call 
            dispatch(generalSettings)
            .getCareerPage({search: ''})
            .then((response: any) => {
                if (response) {
                    const formatForSelectBox = response.map((page: any) => {
                        if (page.is_career_page == true) {
                            setCareerPageSelected(page.id);
                        }
                        return {
                            label: page.title,
                            value: page.id,
                        };
                    });
                    setCareerPageList(formatForSelectBox);
                }
            });

    }, []);

    useEffect(() => {
        const settingsFieldFilter = allSettings.filter(
            (data: any) => data.type === 'general_setting'
        );
        setSettingsField(settingsFieldFilter);
        const settingsInitiateValue = allSettings.map((settings: any) => {
            return {
                name: settings.name,
                value: settings.value,
            };
        });
        setSettingValues(settingsInitiateValue);

        const setInitialcurrency = allSettings.filter(
            (curr: any) => curr.name === 'currency_symbol'
        );
        setCurrencyValue(setInitialcurrency[0]?.value);
    }, [allSettings]);

    const generateFormField = (settings: any) => {
        if (
            settings.form_type === 'text' ||
            settings.form_type === 'number' ||
            settings.form_type === 'password'
        ) {
            return (
                <input
                    type={settings.form_type}
                    name={settings.name}
                    defaultValue={settings.value}
                    placeholder={settings.placeholder}
                    className={`!text-b2-table ${inputStyle}`}
                    onChange={(e) =>
                        settingsOnChange({
                            name: settings.name,
                            value: e.target.value,
                        })
                    }
                />
            );
        } else if (settings.form_type === 'color') {
            return (
                <div className="h-[42px] flex items-center justify-between border border-solid border-border-mid rounded pr-[15px]">
                    <button
                        type="button"
                        className="h-[42px] flex items-center flex-1 gap-2.5 pl-[15px] !rounded-[4px] !border-0 !ring-0"
                        onClick={() =>
                            setColorPickerVisiable({
                                visiable: true,
                                name: settings.name,
                            })
                        }
                    >
                        <span
                            className="h-[25px] w-[25px] !rounded-[4px] !border-0 !ring-0"
                            style={{
                                backgroundColor: getArrayValueByKey(
                                    settingValues,
                                    settings.name
                                ),
                            }}
                        ></span>
                        <span className="text-[14px] text-b2-table leading-[1]">
                            {getArrayValueByKey(settingValues, settings.name)}
                        </span>
                    </button>
                    {colorPickerVisiable.visiable &&
                    colorPickerVisiable.name === settings.name ? (
                        <div className="react-colorful-picker absolute">
                            <div className="absolute z-50 left-[-16px] top-[18px]">
                                <HexColorPicker
                                    color={getArrayValueByKey(
                                        settingValues,
                                        settings.name
                                    )}
                                    onChange={(color) => {
                                        settingsOnChange({
                                            name: settings.name,
                                            value: color,
                                        });
                                    }}
                                />
                                <HexColorInput
                                    color={getArrayValueByKey(
                                        settingValues,
                                        settings.name
                                    )}
                                    onChange={(color) => {
                                        settingsOnChange({
                                            name: settings.name,
                                            value: color,
                                        });
                                    }}
                                    prefixed
                                />
                            </div>
                            <button
                                type="button"
                                className="fixed top-0 right-0 bottom-0 left-0 cursor-default"
                                onClick={() =>
                                    setColorPickerVisiable({
                                        visiable: false,
                                        name: '',
                                    })
                                }
                            />
                        </div>
                    ) : null}
                    {((settings.name == 'primary_color' &&
                        settings.value != '#323da5') ||
                        (settings.name == 'secondary_color' &&
                            settings.value != '#ff7f5c')) && (
                        <Button
                            type="button"
                            text="Reset"
                            icon="tio-restore text-[16px]"
                            buttonCustomClass="text-b3-meta text-[13px]"
                            onClick={() => {
                                settings.value =
                                    settings.name == 'primary_color'
                                        ? '#ff7f5c'
                                        : '#323da5';
                                settingsOnChange({
                                    name: settings.name,
                                    value:
                                        settings.name == 'primary_color'
                                            ? '#ff7f5c'
                                            : '#323da5',
                                });
                            }}
                        />
                    )}
                </div>
            );
        } else if (settings.form_type === 'switcher') {
            return (
                <SwitchCheckbox
                    parentClass="h-[42px] flex items-center border border-solid border-border-mid rounded px-[15px]"
                    id={settings.name}
                    initialValue={settings.value == 'true' ? true : false}
                    onChange={(val: any) => {
                        settingsOnChange({
                            name: settings.name,
                            value: JSON.stringify(val.value),
                        });
                    }}
                    label
                />
            );
        } else if (
            settings.form_type === 'select' &&
            settings.name === 'currency_symbol'
        ) {
            return (
                <Input
                    type="select"
                    name={settings.name}
                    value={currencyValue}
                    select2Style={selectStylesSM}
                    isSearchable={true}
                    options={currenciesSymbol}
                    onChange={(value) => {
                        settingsOnChange({
                            name: settings.name,
                            value: value.value.value,
                        });
                        setCurrencyValue(value?.value?.value);
                    }}
                    areaClassName="input-shadow-none"
                />
            );
        } else if (
            settings.form_type === 'select' &&
            settings.name === 'career_page'
        ) {
            return (
                <Input
                    type="select"
                    name={settings.name}
                    value={careerPageSelected}
                    select2Style={selectStylesSM}
                    isSearchable={true}
                    options={careerPageList}
                    onChange={(value) => {
                        settingsOnChange({
                            name: settings.name,
                            value: value.value.value,
                        });
                        setCareerPageSelected(value?.value?.value);
                    }}
                    areaClassName="input-shadow-none"
                />
            );
        }
    };

    const settingsOnChange = (inputSettings: any) => {
        const modifySettingsValues = settingValues.map((settings: any) => {
            return {
                name: settings.name,
                value:
                    inputSettings.name === settings.name
                        ? inputSettings.value
                        : settings.value,
            };
        });
        setSettingValues(modifySettingsValues);
    };

    const settingsOnSubmit = () => {
        dispatch(generalSettings)
            .updateGeneralSettings({
                settings: settingValues,
            })
            .then((response: any) => {
                if (response.length > 0) {
                    if (response) {
                        const getUpdatedCurrency = response?.filter(
                            (data: any) => data.name === 'currency_symbol'
                        );
                        dispatch(generalSettings).setGeneralSettings({
                            ...getSettings,
                            currency_symbol: getUpdatedCurrency?.[0]?.value,
                        });
                    }
                    SwalSuccess({
                        title: __(
                            'Settings Save Successfully',
                            'ai-job-listing'
                        ),
                    });
                }
            });
    };
    
    return (
        <div className="max-w-[690px]">
            <PageTitle text="Career Page Design" backButton />
            <div className="bg-white p-[30px] rounded">
                {settingsLoading ? (
                    <LoaderLine line={15} />
                ) : (
                    <>
                        <div className="grid grid-cols-2 gap-5">
                            {settingsField?.map((settings: any) => (
                                <div
                                    className={
                                        settings.column_width === 'full'
                                            ? 'col-span-2'
                                            : 'col-span-1'
                                    }
                                    key={settings.id}
                                >
                                    <InputLabel>{settings.label}</InputLabel>
                                    {generateFormField(settings)}
                                </div>
                            ))}
                        </div>
                        <div className="flex item-center gap-5 mt-[30px]">
                            <Button
                                type="button"
                                btnStyle="secondary"
                                text="Save Changes"
                                icon={
                                    settingSaveLoading &&
                                    'animate-spin tio-refresh'
                                }
                                onClick={settingsOnSubmit}
                            />
                        </div>
                    </>
                )}
            </div>
        </div>
    );
};

export default CareerPageSettings;
