/**
 * External dependencies.
 */
import { __ } from '@wordpress/i18n';
import { useState, useEffect } from '@wordpress/element';
import { useSelect, useDispatch } from '@wordpress/data';
import { useParams } from 'react-router-dom';

/**
 * Internal dependencies.
 */
import PageTitle from '../../../../../components/layout/PageTitle';
import Button from '../../../../../components/button/Button';
import { Input } from '../../../../../components/form/Input';
import SwitchCheckbox from '../../../../../components/form/SwitchCheckbox';
import LoaderLine from '../../../../../components/loader/LoaderLine';
import generalSettings from '../../../../../data/general-settings';
import { fallbackCopyTextHandler } from '../../../../../utils/Global';

const EmailTemplateDetails = () => {
    const params = useParams();
    const dispatch = useDispatch();
    const [emailTemplate, setEmailTemplate] = useState<object>({});
    const [copyVariable, setCopyVariable] = useState<object>({
        message: false,
        id: 1,
    });

    const loadingTemplateDetails: any = useSelect(
        (select) => select(generalSettings).getEmailTemplateDetailsLoading(),
        []
    );
    const loadingTemplateSave: any = useSelect(
        (select) => select(generalSettings).getEmailTemplateSaveLoading(),
        []
    );

    const templateDynamicVariable = [
        {
            id: 1,
            variable: '[applicant_name]',
        },
        {
            id: 2,
            variable: '[applicant_mail]',
        },
        {
            id: 3,
            variable: '[admin_mail_notification]',
        },
        {
            id: 4,
            variable: '[job_title]',
        },
    ];

    // Variable Copy Hanlder
    const textCopyHanlder = (event: any, variableId: number) => {
        const textToCopy = event.target.innerText;
        fallbackCopyTextHandler(textToCopy).then((response) => {
            if (response) {
                setCopyVariable({
                    message: response.message,
                    id: variableId,
                });
            }
        });
    };

    useEffect(() => {
        dispatch(generalSettings)
            .getEmailTemplateDetails(params.id)
            .then((response: any) => {
                if (response) {
                    setEmailTemplate(response);
                }
            });
    }, [params.id]);

    const onChangeFormData = (input: any) => {
        setEmailTemplate({
            ...emailTemplate,
            [input.name]: input.value,
        });
    };

    const templateOnSubmit = () => {
        dispatch(generalSettings).saveEmailTemplate(emailTemplate);
    };

    return (
        <>
            <PageTitle text={emailTemplate?.title} backButton />
            <div className="flex gap-6">
                <div className="flex-1 bg-white rounded p-[30px]">
                    {loadingTemplateDetails ? (
                        <LoaderLine line={22} />
                    ) : (
                        <>
                            <div className="flex items-center justify-between mb-5">
                                <div className="text-headline text-[15px] font-medium">
                                    Send Notification
                                </div>
                                <div>
                                    <SwitchCheckbox
                                        id="has_notification_status"
                                        initialValue={
                                            emailTemplate?.has_notification_status === '1'
                                                ? true
                                                : false
                                        }
                                        onChange={(val: any) => {
                                            onChangeFormData({
                                                name: val.name,
                                                value:
                                                    val.value === true
                                                        ? '1'
                                                        : '0',
                                            });
                                        }}
                                        sizeLg
                                    />
                                </div>
                            </div>
                            <div className="mb-5">
                                <Input
                                    type="text"
                                    label={__(
                                        'Email Subject *',
                                        'ai-job-listing'
                                    )}
                                    name="subject"
                                    value={emailTemplate?.subject}
                                    onChange={onChangeFormData}
                                />
                            </div>
                            <div className="mb-5">
                                <Input
                                    type="textarea"
                                    rows={6}
                                    placeholder="Write Email Message"
                                    label={__(
                                        'Email Message *',
                                        'ai-job-listing'
                                    )}
                                    name="message"
                                    value={emailTemplate?.message}
                                    onChange={onChangeFormData}
                                />
                            </div>
                            <div>
                                <Button
                                    type="button"
                                    btnStyle="secondary"
                                    text="Save"
                                    icon={
                                        loadingTemplateSave
                                            ? 'tio-autorenew text-[16px] animate-spin'
                                            : ''
                                    }
                                    disabled={
                                        loadingTemplateSave ? true : false
                                    }
                                    onClick={templateOnSubmit}
                                />
                            </div>
                        </>
                    )}
                </div>
                <div className="w-[340px]">
                    <div className="bg-white rounded py-5 px-[30px]">
                        <div className="border-b border-solid border-border-mid text-[18px] text-headline font-bold pb-2.5 mb-5">
                            Email Dynamic Variable
                        </div>
                        <div className="grid gap-2.5">
                            {templateDynamicVariable?.map((data) => (
                                <button
                                    key={data.id}
                                    onClick={(e) => textCopyHanlder(e, data.id)}
                                    className="flex items-center justify-between px-[15px] py-[6px] border border-border-mid rounded text-left text-[14px] text-placeholder"
                                >
                                    <span>{data.variable}</span>
                                    <span className="pointer-events-none transition-all">
                                        {copyVariable?.message &&
                                        copyVariable.id === data.id ? (
                                            <i className="tio-all_done text-secondary"></i>
                                        ) : (
                                            <i className="tio-copy"></i>
                                        )}
                                    </span>
                                </button>
                            ))}
                        </div>
                    </div>
                </div>
            </div>
        </>
    );
};

export default EmailTemplateDetails;
