/**
 * External dependencies.
 */
import { __ } from '@wordpress/i18n';
import { useSelect } from '@wordpress/data';

/**
 * Internal dependencies.
 */
import PageTitle from '../../../../../components/layout/PageTitle';
import Table from '../../../../../components/table/Table';
import Button from '../../../../../components/button/Button';
import generalSettings from '../../../../../data/general-settings';
import LoadingBox from '../../../../../components/loader/Loading';

const EmailTemplates = () => {
    const emailTemplates: any = useSelect(
        (select) => select(generalSettings).getEmailTemplates(),
        []
    );
    const emailTemplatesLoading: any = useSelect(
        (select) => select(generalSettings).getEmailTemplatesLoading(),
        []
    );

    const tableHeader = [
        {
            key: 'name',
            title: 'Name',
        },
        {
            key: 'receiver',
            title: 'Receiver',
            class: 'text-center',
            bodyClass: 'text-center',
        },
        {
            key: 'action',
            title: 'Action',
            class: 'w-[135px]',
        },
    ];

    return (
        <>
            <PageTitle text="Email Templates" backButton />
            {emailTemplatesLoading ? (
                <LoadingBox block={2} />
            ) : (
                <Table header={tableHeader} body={emailTemplates}>
                    <div customKey="name">
                        {(template: any) => template.name}
                    </div>
                    <div customKey="receiver">
                        {(template: any) => 'Applicant'}
                    </div>
                    <div customKey="action">
                        {(template: any) => (
                            <Button
                                href={`/settings/general/email-templates/${template.id}`}
                                text="View Details"
                                btnStyle="action"
                                outline
                            />
                        )}
                    </div>
                </Table>
            )}
        </>
    );
};

export default EmailTemplates;
