/* eslint-disable @wordpress/i18n-no-variables */
/**
 * External dependencies.
 */
import { useState, useEffect } from '@wordpress/element';
import { useSelect } from '@wordpress/data';
import { Link } from 'react-router-dom';
import { __ } from '@wordpress/i18n';

/**
 * Internal dependencies.
 */
import settingStore from '../../../data/settings';
import PageTitle from '../../../components/layout/PageTitle';
import LoadingBox from '../../../components/loader/Loading';

const Settings = () => {
    const [settingsBlocks, setSettingsBlocks] = useState<Array<any>>([]);
    const [settingSearchText, setSettingSearchText] = useState<string>('');

    const settingsAttribute: any = useSelect(
        (select) => select(settingStore).getSettingsAttributes(),
        []
    );
    const loadingSettingsAttribute: boolean = useSelect(
        (select) => select(settingStore).getLoadingSettings(),
        []
    );
    useEffect(() => {
        const prepareSettingsBlocks = [
            {
                id: 1,
                key: 'general_settings',
                title: 'GENERAL SETTINGS',
                settings: [
                    {
                        id: 1,
                        name: 'Career Page Design',
                        icon: 'tio-book_outlined',
                        slug: '/settings/general/career-page',
                    }, 
                    {
                        id: 2,
                        name: 'Email Templates',
                        icon: 'tio-email_outlined',
                        slug: '/settings/general/email-templates',
                    },
                    {
                        id: 3,
                        name: 'AI Settings',
                        icon: 'tio-magic_wand',
                        slug: '/settings/general/ai-settings',
                    },
                ],
            },
            {
                id: 2,
                key: 'job_settings',
                title: 'DYNAMIC DATA',
                settings: settingsAttribute,
            },
        ];

        const filterSettings = prepareSettingsBlocks
            .map((block) => {
                const filteredSettings = block.settings.filter((setting: any) =>
                    setting.name
                        .toLowerCase()
                        .includes(settingSearchText.toLowerCase())
                );

                return {
                    ...block,
                    settings: filteredSettings,
                };
            })
            .filter((block) => block.settings.length > 0);

        if (settingSearchText.length > 0) {
            setSettingsBlocks(filterSettings);
        } else {
            setSettingsBlocks(prepareSettingsBlocks);
        }
    }, [settingsAttribute, settingSearchText]);

    return (
        <>
            <PageTitle text="Settings" />
            <div className="relative mb-[30px]">
                <button
                    type="submit"
                    className=" absolute top-[4px] left-[20px] z-10 text-[24px] text-b3-meta"
                >
                    <i className="tio-search"></i>
                </button>
                <input
                    name="settings_search"
                    type="text"
                    placeholder="Search items on settings"
                    onChange={(text) => setSettingSearchText(text.target.value)}
                    className="w-[440px] h-[50px] !pl-[54px] !py-1 !px-[15] text-[15px] text-b3-meta !border !border-solid !border-border-mid !rounded focus:!outline-none focus:!shadow-none focus:ring-0"
                />
            </div>
            {loadingSettingsAttribute ? (
                <LoadingBox block={loadingSettingsAttribute.length} />
            ) : (
                <>
                    {settingsBlocks.length > 0 ? (
                        settingsBlocks.map((block) => (
                            <div key={block.id} className="mb-[30px]">
                                <div className="mb-5 text-b4-mid text-b1-notice-comment uppercase">
                                    {block.title}
                                </div>
                                <div className="flex items-center flex-wrap gap-5">
                                    {block.settings
                                        .filter(
                                            (setting: any) =>
                                                setting?.permission !== false
                                        )
                                        .sort((a: any, b: any) =>
                                            a.name.localeCompare(b.name)
                                        )
                                        .map((setting: any) => (
                                            <Link
                                                to={
                                                    block.key === 'job_settings'
                                                        ? 'jobs/' + setting.slug
                                                        : setting.slug
                                                }
                                                className="no-underline shadow-none outline-none focus:shadow-none"
                                                key={setting.id}
                                            >
                                                <div className="group h-[144px] w-[210px] flex items-center justify-center flex-col gap-2.5 p-2.5 bg-white rounded border border-white transition-all hover:border-primary hover:bg-primary">
                                                    <div className="h-[50px] w-[50px] flex items-center justify-center rounded-full text-[24px] bg-background text-primary">
                                                        <i
                                                            className={
                                                                setting.icon
                                                            }
                                                        ></i>
                                                    </div>
                                                    <span className="text-[14px] text-headline font-medium transition-all group-hover:text-white">
                                                        {__(
                                                            `${setting.name}`,
                                                            'ai-job-listing'
                                                        )}
                                                    </span>
                                                </div>
                                            </Link>
                                        ))}
                                </div>
                            </div>
                        ))
                    ) : (
                        <div className="text-[20px] text-headline font-medium">
                            No Data Found
                        </div>
                    )}
                </>
            )}
        </>
    );
};

export default Settings;
