/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { useNavigate } from 'react-router-dom';
import { useState } from '@wordpress/element';
import { useSelect, useDispatch } from '@wordpress/data';
import nl2br from 'react-nl2br';
/**
 * Internal dependencies.
 */
import joblistingstore from '../../../data/careers';

const FormStepFour = ({ baseUrl, jobData, settings }: any) => {
    const dispatch = useDispatch();
    const navigate = useNavigate();
    const [submitCheck, setSubmitCheck] = useState<number>(1);
    // Store cv submit form data
    const getCvFormData: any = useSelect(
        (select) => select(joblistingstore).getCvPostForm(),
        []
    );

    // Form Submit Handlers
    const submitApplicationHandler = () => {
        dispatch(joblistingstore)
            .saveCvPostForm({
                job_id: jobData?.id,
                _wpnonce: settings._wpnonce,
                data: {
                    ...getCvFormData,
                },
            })
            .then((response: any) => {
                if (response) {
                    dispatch(joblistingstore).setCvFormStep(1);
                    dispatch(joblistingstore).setCvFormStepCompleted(1);
                    navigate(`${baseUrl}/thank-you`);
                }
            });
    };

    return (
        <div className="job-apply-form-preview">
            <h3 className="section-title">Review Your Information </h3>
            {/* Required Information */}
            <div className="preview-block">
                <div className="preview-items">
                    <div className="preview-list-item">
                        <div className="profile-info-preview">
                            {getCvFormData?.profile_image && (
                                <div className="attachment-img">
                                    <img
                                        src={URL.createObjectURL(
                                            getCvFormData?.profile_image
                                        )}
                                        alt={getCvFormData?.full_name}
                                    />
                                </div>
                            )}
                            <div className="contact-info">
                                <div className="name">
                                    {getCvFormData?.full_name}
                                </div>
                                <a
                                    href={`mailto:${getCvFormData?.email}`}
                                    className="email"
                                >
                                    <i className="tio-email"></i>
                                    {getCvFormData?.email}
                                </a>
                                <a
                                    href={`tel:${getCvFormData?.phone_number}`}
                                    className="email phone"
                                >
                                    <i className="tio-call_talking_quiet"></i>
                                    {getCvFormData?.phone_number}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {/* Preliminary Questions */}
            <div className="preview-block">
                <div className="preview-header">
                    <h3 className="title">
                        <i className="tio-help_outlined"></i>
                        Preliminary Questions
                    </h3>
                    <button
                        type="button"
                        className="edit-btn"
                        onClick={() =>
                            dispatch(joblistingstore).setCvFormStep(2)
                        }
                    >
                        Edit
                    </button>
                </div>
                <div className="preview-items">
                    <div className="preview-list-item">
                        <div className="label">
                            Were you referred to this position by an employee of
                            this company?
                        </div>
                        <div className="value text-capitalize">
                            {getCvFormData?.referred_to}
                        </div>
                        {getCvFormData?.referred_to === 'yes' && (
                            <>
                                <div className="employee-list-label">
                                    List the name of the employees:
                                </div>
                                <div>
                                    {nl2br(getCvFormData?.referred_person)}
                                </div>
                            </>
                        )}
                    </div>
                    <div className="preview-list-item">
                        <div className="label">
                            Do you have any relation to an existing employee at
                            this company?
                        </div>
                        <div className="value text-capitalize">
                            {getCvFormData?.any_relation}
                        </div>
                        {getCvFormData?.any_relation === 'yes' && (
                            <>
                                <div className="employee-list-label">
                                    List the name of the employees:
                                </div>
                                <div>
                                    {nl2br(getCvFormData?.relative_person)}
                                </div>
                            </>
                        )}
                    </div>
                </div>
            </div>
            {/* Schedule and Salary */}
            <div className="preview-block">
                <div className="preview-header">
                    <h3 className="title">
                        <i className="tio-money"></i>Schedule and Salary
                    </h3>
                    <button
                        type="button"
                        className="edit-btn"
                        onClick={() =>
                            dispatch(joblistingstore).setCvFormStep(2)
                        }
                    >
                        Edit
                    </button>
                </div>
                <div className="preview-items preview-item-half-grid">
                    <div className="preview-list-item">
                        <div className="label">Work Experience (In Year)</div>
                        <div className="value">
                            {getCvFormData?.work_experience?.label}
                        </div>
                    </div>
                    <div className="preview-list-item">
                        <div className="label">Joining Notice Period</div>
                        <div className="value">
                            {getCvFormData?.when_join?.label}
                        </div>
                    </div>
                    <div className="preview-list-item">
                        <div className="label">Current Salary</div>
                        <div className="value">
                            {getCvFormData?.current_salary}
                        </div>
                    </div>
                    <div className="preview-list-item">
                        <div className="label">Expected Salary</div>
                        <div className="value">
                            {getCvFormData?.expected_salary}
                        </div>
                    </div>
                    <div className="preview-list-item">
                        <div className="label">Education</div>
                        <div className="value">
                            {getCvFormData?.education?.label}
                        </div>
                    </div>
                    <div className="preview-list-item">
                        <div className="label">Current Company</div>
                        <div className="value">
                            {getCvFormData?.current_company_name}
                        </div>
                    </div>
                </div>
                <div className="preview-items">
                    {getCvFormData?.explain_work_experience && (
                        <div className="preview-list-item">
                            <div className="label">Work Experience</div>
                            <div className="value">
                                {getCvFormData?.explain_work_experience}
                            </div>
                        </div>
                    )}
                    {getCvFormData?.protfolio_link && (
                        <div className="preview-list-item">
                            <div className="label">Portfolio</div>
                            <div className="value">
                                {getCvFormData?.protfolio_link}
                            </div>
                        </div>
                    )}
                    {getCvFormData?.additional_comments && (
                        <div className="preview-list-item">
                            <div className="label">Additional Comments</div>
                            <div className="value">
                                {getCvFormData?.additional_comments}
                            </div>
                        </div>
                    )}
                </div>
            </div>
            {/* Resume and cover letter */}
            <div className="preview-block">
                <div className="preview-header">
                    <h3 className="title">
                        <i className="tio-attachment_diagonal"></i>Attachments
                    </h3>
                    <button
                        type="button"
                        className="edit-btn"
                        onClick={() =>
                            dispatch(joblistingstore).setCvFormStep(3)
                        }
                    >
                        Edit
                    </button>
                </div>
                <div className="preview-items">
                    <div className="preview-list-item">
                        {getCvFormData?.resume && (
                            <div className="attachment-file">
                                <i className="tio-file_text_outlined"></i>
                                {getCvFormData.resume.name}
                            </div>
                        )}
                    </div>
                </div>
            </div>
            <div className="application-submission-agreement">
                <input
                    type="checkbox"
                    id="resume-agreement"
                    name="resume-agreement"
                    onChange={(e) => {
                        setSubmitCheck(e.target.checked === true ? 0 : 1);
                    }}
                />
                <label htmlFor="resume-agreement">
                    I agree that all the information provided is true and
                    accurate.
                </label>
            </div>
            <div className="button-group">
                <div className="back-btn">
                    <button
                        type="button"
                        onClick={() =>
                            dispatch(joblistingstore).setCvFormStep(3)
                        }
                    >
                        Back
                    </button>
                </div>
                <div className="apply-btn">
                    <button
                        type="button"
                        onClick={submitApplicationHandler}
                        disabled={submitCheck === 1 ? true : false}
                    >
                        Submit Application
                    </button>
                </div>
            </div>
        </div>
    );
};

export default FormStepFour;
