/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { useState, useEffect } from '@wordpress/element';
import { useSelect, useDispatch } from '@wordpress/data';
import { useForm, SubmitHandler } from 'react-hook-form';
import { ErrorMessage } from '@hookform/error-message';
/**
 * Internal dependencies.
 */
import joblistingstore from '../../../data/careers';

const FormStepThree = ({ baseUrl }: any) => {
    const [formBlocks, setFormBlocks] = useState<any>({});
    const [attachment, setAttachment] = useState<any>({});
    const dispatch = useDispatch();
    const {
        register,
        handleSubmit,
        formState: { errors },
    } = useForm<any>();

    // Cv Submit form dynamic fields
    const cvFormFields: any = useSelect(
        (select) => select(joblistingstore).getCvPostFormFields(),
        []
    );
    // Store cv submit form data
    const getCvFormData: object = useSelect(
        (select) => select(joblistingstore).getCvPostForm(),
        []
    );

    useEffect(() => {
        const findBlock = cvFormFields.filter(
            (data: any) => data.block_id === 3
        );
        if (!findBlock[0]) return;
        setFormBlocks(findBlock[0]);
    }, [cvFormFields]);

    // Generate Form field by type
    const generateFieldByType = (fields: any) => {
        if (fields.type === 'file' && fields.doc_attachment) {
            return (
                <div
                    key={fields.name}
                    className={
                        fields.half_width === false
                            ? 'job-form-col form-col-span-full'
                            : 'job-form-col'
                    }
                >
                    <div className="attachment-upload-large">
                        {attachment?.length > 0 || getCvFormData?.resume ? (
                            <div className="upload-brief-text">
                                <h5 className="title-text">
                                    {attachment[0]?.name ??
                                        getCvFormData?.resume?.name}
                                </h5>
                                <button
                                    type="button"
                                    className="text-placeholder"
                                    onClick={() => {
                                        dispatch(joblistingstore).setCvPostForm(
                                            {
                                                ...getCvFormData,
                                                resume: null,
                                            }
                                        );
                                        setAttachment({});
                                    }}
                                >
                                    Remove File
                                </button>
                            </div>
                        ) : (
                            <>
                                <input
                                    type={fields.type}
                                    accept=".pdf"
                                    {...register(fields.name, {
                                        onChange: (e) => {
                                            setAttachment(e.target.files);
                                        },
                                        required: {
                                            value: getCvFormData[fields.name]
                                                ? false
                                                : true,
                                            message: 'Document is required',
                                        },
                                        validate: {
                                            acceptedFormats: (value) => {
                                                if (!value[0]) return true; // Skip validation if no file is selected
                                                return (
                                                    [
                                                        'application/pdf',
                                                    ].includes(value[0].type) ||
                                                    'Only PDF files are allowed'
                                                );
                                            },
                                            acceptedSize: (value) => {
                                                if (!value[0]) return true; // Skip validation if no file is selected
                                                const acceptedSize = 5242880; // Define accepted file Sizes
                                                return (
                                                    acceptedSize >
                                                        value[0].size ||
                                                    'File size should be less than 5 MB'
                                                ); // Check if selected file type is in the accepted formats
                                            },
                                        },
                                    })}
                                />
                                <div className="upload-brief-text">
                                    <h5 className="title-text">
                                        Drop PDF File Here or Click to Browse My
                                        Computer
                                    </h5>
                                    <span className="text-placeholder">
                                        The maximum file size is (5 Mb) and the
                                        supported file type is (.pdf)
                                    </span>
                                </div>
                            </>
                        )}
                    </div>
                    <ErrorMessage
                        errors={errors}
                        name={fields.name}
                        render={({ message }) => (
                            <span className="form-field-error">{message}</span>
                        )}
                    />
                </div>
            );
        }
    };

    // Form Submit Handlers
    const onSubmit: SubmitHandler<any> = (formData) => {
        dispatch(joblistingstore).setCvPostForm({
            ...getCvFormData,
            ...formData,
            resume: getCvFormData?.resume ?? formData?.resume[0],
        });
        dispatch(joblistingstore).setCvFormStep(4);
        dispatch(joblistingstore).setCvFormStepCompleted(4);
    };

    return (
        <>
            <form
                onSubmit={handleSubmit(onSubmit)}
                encType="multipart/form-data"
                className="job-apply-form"
            >
                <div className="job-apply-step-three">
                    {formBlocks?.sub_blocks?.map((block: any) => (
                        <div
                            key={block.sub_block_id}
                            className="job-form-blocks"
                        >
                            <h3 className="form-block-title">
                                {block.sub_block_name}
                            </h3>
                            <div className="job-form-row">
                                {block.field_options?.map((field: any) =>
                                    generateFieldByType(field)
                                )}
                            </div>
                        </div>
                    ))}
                    <div className="button-group">
                        <div className="back-btn">
                            <button
                                type="button"
                                onClick={() =>
                                    dispatch(joblistingstore).setCvFormStep(2)
                                }
                            >
                                Back
                            </button>
                        </div>
                        <div className="apply-btn">
                            <button type="submit">Next</button>
                        </div>
                    </div>
                </div>
            </form>
        </>
    );
};

export default FormStepThree;
