/**
 * External dependencies
 */
import { useState, useEffect } from '@wordpress/element';
import { useSelect, useDispatch } from '@wordpress/data';
import { useParams } from 'react-router-dom';

/**
 * Internal dependencies.
 */
import careerStore from '../../../data/careers';
import FormStepOne from '../apply-form/FormStepOne';
import FormStepTwo from '../apply-form/FormStepTwo';
import FormStepThree from '../apply-form/FormStepThree';
import Loader from '../../../components/loader/Loader';
import FormStepFour from './FormStepFour';

const JobApply = ({ baseUrl, settings }: any) => {
    const dispatch = useDispatch();
    const params = useParams();
    const postSlug = params.slug;
    const [jobData, setJobData] = useState<any>({});

    const cvFormFields: any = useSelect(
        (select) => select(careerStore).getCvPostFormFields(),
        []
    );

    const cvFormStep: number = useSelect(
        (select) => select(careerStore).getCvFormStep(),
        []
    );
    const cvFormStepCompleted: number = useSelect(
        (select) => select(careerStore).getCvFormStepCompleted(),
        []
    );
    const cvFormLoading: boolean = useSelect(
        (select) => select(careerStore).getCvFormLoading(),
        []
    );

    // Step Control
    const setCvFormSteps = (step: any) => {
        if (cvFormStepCompleted >= step) {
            dispatch(careerStore).setCvFormStep(step);
        }
    };

    useEffect(() => {
        dispatch(careerStore)
            .getJobs({
                column: '*',
                status: ['active'],
                slug: postSlug,
            })
            .then((response: any) => {
                if (response) {
                    setJobData({
                        id: response[0]?.id,
                        slug: response[0]?.slug,
                        is_required_cv_photo: response[0]?.is_required_cv_photo,
                    });
                }
            });
    }, [postSlug]);

    // Step Form Control
    const GetFormStep = () => {
        switch (cvFormStep) {
            case 2:
                return <FormStepTwo />;
                break;
            case 3:
                return <FormStepThree baseUrl={baseUrl} />;
                break;
            case 4:
                return <FormStepFour baseUrl={baseUrl} jobData={jobData} settings={settings} />;
                break;
            default:
                return <FormStepOne jobData={jobData} settings={settings} />;
                break;
        }
    };

    return (
        <div className="ai-job-listing-apply">
            <div className="job-listing-apply-container">
                <div className="job-form-steps">
                    {cvFormFields?.map((data: any) => (
                        <button
                            className={`step-button ${
                                cvFormStep >= data.block_id ? 'active' : ''
                            } ${cvFormStep > data.block_id ? 'done' : ''}`}
                            key={data.block_id}
                            onClick={() => setCvFormSteps(data.block_id)}
                        >
                            <span
                                className={`step-text ${
                                    cvFormStep >= data.block_id ? 'active' : ''
                                }`}
                            >
                                {data.block_name}
                            </span>
                            <span
                                className={`step-count ${
                                    cvFormStep >= data.block_id ? 'active' : ''
                                }`}
                            >
                                {cvFormStep > data.block_id ? (
                                    <i className="tio-done"></i>
                                ) : (
                                    data.block_id
                                )}
                            </span>
                        </button>
                    ))}
                </div>
                <div className="job-apply-form-wrap">
                    {cvFormLoading ? <Loader /> : <GetFormStep />}
                </div>
            </div>
        </div>
    );
};

export default JobApply;
