/**
 * External dependencies
 */
import { render } from '@wordpress/element';
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import { useSelect, register } from '@wordpress/data';

/**
 * Internal dependencies.
 */
import careerStore from '../../data/careers';
import JobListing from './job-listing/JobListing';
import JobApply from './apply-form/JobApply';
import JobDetails from './job-details/JobDetails';
import ThankYou from './apply-form/ThankYou';
import Error404 from './Error404';

// Import the stylesheet for the plugin.
import '../../style/career.scss';

// Register Store
register(careerStore);

const Careers = (props: any) => {
    const basePermalink = props.wpJobListingNode.getAttribute(
        'data-base-permalink'
    );
    const siteBasePath = window.location.pathname;
    const pathIndex = siteBasePath.lastIndexOf(basePermalink);
    const baseUrl = siteBasePath.substring(0, pathIndex) + basePermalink;

    const settings: object = useSelect(
        (select) => select(careerStore).getCareerPageSettings(),
        []
    );

    return (
        <div
            className="ai-job-listing-career"
            style={{
                '--primary-color': settings?.primary_color,
                '--secondary-color': settings?.secondary_color,
            }}
        >
            <Router>
                <Routes>
                    <Route
                        path={`${baseUrl}/`}
                        element={
                            <JobListing baseUrl={baseUrl} settings={settings} />
                        }
                    ></Route>
                    <Route
                        path={`${baseUrl}/:slug/apply`}
                        element={
                            <JobApply baseUrl={baseUrl} settings={settings} />
                        }
                    ></Route>
                    <Route
                        path={`${baseUrl}/:slug`}
                        element={
                            <JobDetails baseUrl={baseUrl} settings={settings} />
                        }
                    ></Route>
                    <Route
                        path={`${baseUrl}/thank-you`}
                        element={
                            <ThankYou baseUrl={baseUrl} settings={settings} />
                        }
                    ></Route>
                    <Route
                        path={`${baseUrl}/404`}
                        element={<Error404 baseUrl={baseUrl} />}
                    ></Route>
                </Routes>
            </Router>
        </div>
    );
};

export default Careers;

// Render the App component into the DOM
const wpJobListing = document.getElementById('ai-job-listing-career');

if (wpJobListing) {
    render(<Careers wpJobListingNode={wpJobListing} />, wpJobListing);
}
