/**
 * External dependencies
 */
import { useState, useEffect } from '@wordpress/element';
import { __ } from '@wordpress/i18n';
import { useSelect, useDispatch } from '@wordpress/data';
/**
 * Internal dependencies.
 */
import careerStore from '../../../data/careers';
import Collapse from '../../../components/collapse/Collapse';
import LoaderLine from '../../../components/loader/LoaderLine';

type Props = {
    sendParamToParent: any;
    setting: any;
};

const JobListingSidebar = ({ sendParamToParent }: Props) => {
    const dispatch = useDispatch();
    const [attributeParams, setAttributeParams] = useState<any>([]);
    const [selectedJobTypeId, setSelectedJobTypeId] = useState<any>('');
    const [selectedDepartmentId, setSelectedDepartmentId] = useState<any>('');
    const [selectedJobShiftId, setSelectedJobShiftId] = useState<any>('');
    const [selectedLocationId, setSelectedLocationId] = useState<any>('');
    const sidebarData: any = useSelect(
        (select) => select(careerStore).getSidebarFilterData(),
        []
    );
    const sidebarDataLoading: any = useSelect(
        (select) => select(careerStore).getSidebarFilterLoading(),
        []
    );

    const attributeFilterHandler = (attribute: any) => {
        switch (attribute.name) {
            case 'job-types':
                setSelectedJobTypeId(attribute.id);
                setSelectedDepartmentId('');
                setSelectedJobShiftId('');
                setSelectedLocationId('');
                break;
            case 'job-departments':
                setSelectedDepartmentId(attribute.id);
                setSelectedJobShiftId('');
                setSelectedLocationId('');
                break;
            case 'job-shifts':
                setSelectedJobShiftId(attribute.id);
                setSelectedLocationId('');
                break;
            case 'job-locations':
                setSelectedLocationId(attribute.id);
                break;
        }

        setAttributeParams(() => {
            if (attributeParams.length > 0) {
                if (attribute.name === 'job-types') {
                    return attribute.id ? [attribute] : [];
                } else if (attribute.name === 'job-departments') {
                    const filterDuplicate = attributeParams.filter(
                        (attr: any) => attr.name === 'job-types'
                    );
                    if (attribute.id) {
                        return [...filterDuplicate, attribute];
                    }
                    return [...filterDuplicate];
                } else if (attribute.name === 'job-shifts') {
                    const filterDuplicate = attributeParams.filter(
                        (attr: any) =>
                            attr.name === 'job-types' ||
                            attr.name === 'job-departments'
                    );
                    if (attribute.id) {
                        return [...filterDuplicate, attribute];
                    }
                    return [...filterDuplicate];
                } else if (attribute.name === 'job-locations') {
                    const filterDuplicate = attributeParams.filter(
                        (attr: any) => attr.name !== 'job-locations'
                    );
                    if (attribute.id) {
                        return [...filterDuplicate, attribute];
                    }
                    return [...filterDuplicate];
                }
                // eslint-disable-next-line no-else-return
            } else {
                return [attribute];
            }
        });
    };

    useEffect(() => {
        const prepareAttributeId: any = [];
        const prepareAttributeValueId: any = [];

        for (let i = 0; i < attributeParams.length; i++) {
            const element = attributeParams[i];
            prepareAttributeValueId.push(element.id);
            prepareAttributeId.push(element.attribute_id);
        }

        sendParamToParent({
            job_attributes:
                prepareAttributeValueId.length > 0
                    ? prepareAttributeValueId
                    : [],
        });

        dispatch(careerStore).getSidebarFilterData({
            attribute_value_id: prepareAttributeValueId,
            attribute_id: prepareAttributeId,
        });
    }, [attributeParams]);

    return (
        <>
            <div className="sidebar-item-wrap">
                <Collapse
                    buttonText="JOB TYPE"
                    collapseItem={
                        <>
                            {sidebarDataLoading ? (
                                <LoaderLine line={5} />
                            ) : (
                                sidebarData?.jobTypes?.map((type: any) => (
                                    <div
                                        className="form-check"
                                        key={type.attribute_value_id}
                                    >
                                        <input
                                            type="radio"
                                            name={type?.attribute_slug}
                                            id={`${type?.attribute_slug}-${type?.attribute_value_id}`}
                                            value={type.attribute_value_id}
                                            checked={
                                                type.attribute_value_id == selectedJobTypeId
                                            }
                                            onChange={(e) => {
                                                const values = {
                                                    name: e.target.name,
                                                    value: e.target.value,
                                                    id: type.attribute_value_id,
                                                    attribute_id: type.id,
                                                };
                                                attributeFilterHandler(values);
                                            }}
                                        />
                                        <label
                                            htmlFor={`${type?.attribute_slug}-${type?.attribute_value_id}`}
                                        >
                                            {type?.attribute_value}{' '}
                                            {type?.attribute_value != 'All' &&
                                                `(${type.job_count})`}
                                        </label>
                                    </div>
                                ))
                            )}
                        </>
                    }
                />
                <Collapse
                    buttonText="DEPARTMENT"
                    collapseItem={
                        <>
                            {sidebarDataLoading ? (
                                <LoaderLine line={5} />
                            ) : (
                                sidebarData?.departments?.map(
                                    (department: any) => (
                                        <div
                                            className="form-check"
                                            key={department.attribute_value_id}
                                        >
                                            <input
                                                type="radio"
                                                name={
                                                    department?.attribute_slug
                                                }
                                                id={`${department?.attribute_slug}-${department?.attribute_value_id}`}
                                                value={
                                                    department.attribute_value_id
                                                }
                                                checked={
                                                    department.attribute_value_id == selectedDepartmentId
                                                }
                                                onChange={(e) => {
                                                    const values = {
                                                        name: e.target.name,
                                                        value: e.target.value,
                                                        id: department.attribute_value_id,
                                                        attribute_id:
                                                            department.id,
                                                    };
                                                    attributeFilterHandler(
                                                        values
                                                    );
                                                }}
                                            />
                                            <label
                                                htmlFor={`${department?.attribute_slug}-${department?.attribute_value_id}`}
                                            >
                                                {department?.attribute_value}{' '}
                                                {department?.attribute_value != 'All' &&
                                                    `(${department.job_count})`}
                                            </label>
                                        </div>
                                    )
                                )
                            )}
                        </>
                    }
                />
                <Collapse
                    buttonText="JOB SHIFT"
                    collapseItem={
                        <>
                            {sidebarDataLoading ? (
                                <LoaderLine line={5} />
                            ) : (
                                sidebarData?.jobShifts?.map((shift: any) => (
                                    <div
                                        className="form-check"
                                        key={shift.attribute_value_id}
                                    >
                                        <input
                                            type="radio"
                                            name={shift?.attribute_slug}
                                            id={`${shift?.attribute_slug}-${shift?.attribute_value_id}`}
                                            value={shift.attribute_value_id}
                                            checked={
                                                shift.attribute_value_id == selectedJobShiftId
                                            }
                                            onChange={(e) => {
                                                const values = {
                                                    name: e.target.name,
                                                    value: e.target.value,
                                                    id: shift.attribute_value_id,
                                                    attribute_id: shift.id,
                                                };
                                                attributeFilterHandler(values);
                                            }}
                                        />
                                        <label
                                            htmlFor={`${shift?.attribute_slug}-${shift?.attribute_value_id}`}
                                        >
                                            {shift?.attribute_value}{' '}
                                            {shift?.attribute_value != 'All' &&
                                                `(${shift.job_count})`}
                                        </label>
                                    </div>
                                ))
                            )}
                        </>
                    }
                />
                <Collapse
                    buttonText="Locations"
                    collapseItem={
                        <>
                            {sidebarDataLoading ? (
                                <LoaderLine line={5} />
                            ) : (
                                sidebarData?.locations?.map((location: any) => (
                                    <div
                                        className="form-check"
                                        key={location.attribute_value_id}
                                    >
                                        <input
                                            type="radio"
                                            name={location?.attribute_slug}
                                            id={`${location?.attribute_slug}-${location?.attribute_value_id}`}
                                            value={location.attribute_value_id}
                                            checked={
                                                location.attribute_value_id == selectedLocationId
                                            }
                                            onChange={(e) => {
                                                const values = {
                                                    name: e.target.name,
                                                    value: e.target.value,
                                                    id: location.attribute_value_id,
                                                    attribute_id: location.id,
                                                };
                                                attributeFilterHandler(values);
                                            }}
                                        />
                                        <label
                                            htmlFor={`${location?.attribute_slug}-${location?.attribute_value_id}`}
                                        >
                                            {location?.attribute_value}{' '}
                                            {location?.attribute_value != 'All' &&
                                                `(${location.job_count})`}
                                        </label>
                                    </div>
                                ))
                            )}
                        </>
                    }
                />
            </div>
        </>
    );
};

export default JobListingSidebar;
