
/**
 * Internal dependencies
 */
import JobList from '../pages/admin/jobs';
import AiJobDashboard from '../pages/admin/Index';
import Settings from '../pages/admin/settings';
import JobSettingsAttributes from '../pages/admin/settings/jobs/JobSettingsAttributes';
import JobCreate from '../pages/admin/jobs/job-form/JobCreate';
import JobDetails from '../pages/admin/jobs/job-details/JobDetails';
import ApplicantList from '../pages/admin/applicants';
import JobPostThankYou from '../pages/admin/jobs/job-form/ThankYou';
import CareerPageSettings from '../pages/admin/settings/general/CareerPageSettings';
import AiSettings from '../pages/admin/settings/general/AiSettings';
import EmailTemplates from '../pages/admin/settings/general/email-templates';
import EmailTemplateDetails from '../pages/admin/settings/general/email-templates/EmailTemplateDetails';

type Props = {
    jobLimit?: boolean;
};

const routes = ({ jobLimit = false }: Props) => {
    return [
         {
            path: '/',
            element: AiJobDashboard,
            name: 'AI Job Listing',
            icon: 'tio-briefcase_outlined',
            navShow: false,
            permission: true,
        },
        {
            path: '/job-list',
            element: JobList,
            name: 'Job List',
            icon: 'tio-briefcase_outlined',
            navShow: true,
            permission: true,
        },
        {
            path: '/job/list/:id',
            element: JobDetails,
            name: 'Job Details',
            icon: 'tio-briefcase_outlined',
            navShow: false,
            permission: true,
        },
        {
            path: '/job/create',
            element: JobCreate,
            name: 'Job Create',
            icon: 'tio-briefcase_outlined',
            navShow: false,
            permission: jobLimit,
        },
        {
            path: '/job/edit/:id',
            element: JobCreate,
            name: 'Job Update',
            icon: 'tio-briefcase_outlined',
            navShow: false,
            permission: true,
        },
        {
            path: '/job/thank-you',
            element: JobPostThankYou,
            name: 'Job Post Successful',
            icon: 'tio-briefcase_outlined',
            navShow: false,
            permission: true,
        },
        {
            path: '/applicants',
            element: ApplicantList,
            name: 'Applicants',
            icon: 'tio-dashboard_outlined',
            navShow: true,
            permission: true,
        },
        {
            path: '/settings',
            element: Settings,
            name: 'Settings',
            icon: 'tio-settings_outlined',
            navShow: true,
            permission: true,
        },
        {
            path: '/settings/jobs/:slug',
            element: JobSettingsAttributes,
            name: 'Settings Attribute',
            icon: 'tio-settings_outlined',
            navShow: false,
            permission: true,
        },
        {
            path: '/settings/general/career-page',
            element: CareerPageSettings,
            name: 'Career Page Design',
            icon: 'tio-category_outlined',
            navShow: false,
            permission: true,
        }, 
        {
            path: '/settings/general/ai-settings',
            element: AiSettings,
            name: 'AI Settings',
            icon: 'tio-category_outlined',
            navShow: false,
            permission: true,
        }, 
        {
            path: '/settings/general/email-templates',
            element: EmailTemplates,
            name: 'Email Templates',
            icon: 'tio-category_outlined',
            navShow: false,
            permission: true,
        },
        {
            path: '/settings/general/email-templates/:id',
            element: EmailTemplateDetails,
            name: 'Email Templates Details',
            icon: 'tio-category_outlined',
            navShow: false,
            permission: true,
        },
    ];
}

export default routes;
