/**
 * External dependencies
 */
import { format } from 'date-fns';

export const formatDateOnly = (dateString: any) => {
    const date = new Date(dateString);

    return !isNaN(date) ? format(date, 'MMM dd, yyyy') : '';
};

export const getAllDatesBetweenCreateToDeadline = (
    startDate: string,
    endDate: string
) => {
    const dates = [];
    // Copy the start date
    const currentDate = new Date(startDate);
    const today = new Date();
    const lastDate = new Date(endDate);

    // Normalize all dates to remove the time component
    currentDate.setHours(0, 0, 0, 0);
    today.setHours(0, 0, 0, 0);
    lastDate.setHours(0, 0, 0, 0);

    const finalDate = today <= lastDate ? today : lastDate;

    // Loop through dates until reaching the end date
    while (currentDate <= finalDate) {
        dates.push(new Date(currentDate));
        currentDate.setDate(currentDate.getDate() + 1);
    }
    const dateLabel = dates.map((date) => ({
        date: format(date, 'MMM dd, yyyy'),
    }));
    return dateLabel;
};
