// Status Badge Generate By color
export const statusElementGenerate = (status: string) => {
    switch (status) {
        case 'active':
            return (
                <div className="flex items-center gap-[5px] capitalize text-green">
                    <i className="tio-checkmark_circle"></i>
                    <span>{status}</span>
                </div>
            );
        case 'expired':
            return (
                <div className="flex items-center gap-[5px] capitalize text-red">
                    <i className="tio-info"></i>
                    <span>{status}</span>
                </div>
            );
        case 'archieved':
            return (
                <div className="flex items-center gap-[5px] capitalize text-info">
                    <i className="tio-archive"></i>
                    <span>{status}</span>
                </div>
            );
        case 'inactive':
            return (
                <div className="flex items-center gap-[5px] capitalize text-primary">
                    <i className="tio-pause_circle"></i>
                    <span>{status}</span>
                </div>
            );
        case 'draft':
            return (
                <div className="flex items-center gap-[5px] capitalize text-warning">
                    <i className="tio-draft"></i>
                    <span>{status}</span>
                </div>
            );
        default:
            return (
                <div className="flex items-center gap-[5px] capitalize text-primary">
                    <i className="tio-pause_circle"></i>
                    <span>{status}</span>
                </div>
            );
    }
};
