export const snakeCaseToTitleCase = (input: any) => {
    // Replace underscores with spaces
    const stringWithSpaces = input.replace(/_/g, ' ');

    // Split the string into words
    const words = stringWithSpaces.split(' ');

    // Capitalize the first letter of each word
    const titleCaseWords = words.map((word: any) => {
        return word.charAt(0).toUpperCase() + word.slice(1);
    });

    // Join the words back together
    const titleCaseString = titleCaseWords.join(' ');

    return titleCaseString;
};

export const kebabCaseToTitleCase = (input: any) => {
    // Replace dashes with spaces
    const stringWithSpaces = input.replace(/-/g, ' ');
    // Split the string into words
    const words = stringWithSpaces.split(' ');
    // Capitalize the first letter of each word
    const titleCaseWords = words.map((word: any) => {
        return word.charAt(0).toUpperCase() + word.slice(1);
    });
    // Join the words back together
    const titleCaseString = titleCaseWords.join(' ');
    return titleCaseString;
};

export const isAdministrator = (user: any) => {
    return user && user.roles && user.roles.includes('administrator');
};

export const ucfirst = (str: any) => str.charAt(0).toUpperCase() + str.slice(1);
